﻿;//-----------------------------------------------------------------------------------------------------------------
;// UtilsManager.ahk[UTF-8] (2026/02/19 21:00)
;// for AutoHotKey v2.0.21 or later
;//
;// http://coltpythonkingcobra.g1.xrea.com/pseudoTweetdeck/
;//                                             @PseudoTwDk
;//-----------------------------------------------------------------------------------------------------------------
;//
;// ResizeBrowserに同居していたおまけ機能を分離したツール
;//
;// ・VNCクライアントの仮想デスクトップ切り替わり時にアクティブにする
;// ・トリガファイルを定期的に確認する
;// ・CTRL+ALT+LWinでタスクバーの表示非表示を切り替える
;// ・CTRL+ALT+カーソルでスクロール操作をする
;// ・指定ウィンドウを閉じる
;// ・マウスのサイドボタンを置換する
;//
;// 使い方
;//  各種パラメータはiniファイルに記述します
;//

;//多重起動時ダイアログボックスをスキップして既存インスタンスを終了させ新しいインスタンスを起動
#SingleInstance Force

;@Ahk2Exe-AddResource UtilsManager.ico, 1
;@Ahk2Exe-AddResource UtilsManager2.ico, 2
TraySetIcon(,,true)
try{
	TraySetIcon(A_ScriptFullPath,1)
}catch{
	TraySetIcon("UtilsManager.ico")
}
IniFile := "UtilsManager.ini"
IniSect := "APP"

#Include AhkCommon.ahk


;//MouseGetPosはスクリーンを対象とする
CoordMode("Mouse", "Screen")

;//タスクトレイアイコンにメニュー項目追加
A_TrayMenu.Insert("1&", "Reload UtilsManager", handleMenuItemReload)
A_TrayMenu.Insert("2&", "Edit INI file", handleMenuItemEdit)
A_TrayMenu.Insert("3&", "Pause and Suspend", handleMenuItemStop)
A_TrayMenu.Delete("5&")
A_TrayMenu.Delete("4&")

MY_APP_ID := APP_UTILSMANAGER
DEF_MENU := "Pause and Suspend"
A_TrayMenu.Default := DEF_MENU
A_TrayMenu.ClickCount := 1

LoopWait     := Number(IniRead(IniFile, IniSect, "LoopWait", "10"))
topMostVNC   := Number(IniRead(IniFile, IniSect, "TopMostVNC", "0"))
TriggerFile  := IniRead(IniFile, IniSect, "TriggerFile", "")
TriggerExec  := IniRead(IniFile, IniSect, "TriggerExec", "")
hideTaskBar  := Number(IniRead(IniFile, IniSect, "HideTaskbar", "0"))
buttonScroll := Number(IniRead(IniFile, IniSect, "ButtonScroll", "0"))
sideChg1     := Number(IniRead(IniFile, IniSect, "SideButton1", "0"))
sideKey1     := IniRead(IniFile, IniSect, "SideKey1", "Shift")
sideChg2     := Number(IniRead(IniFile, IniSect, "SideButton2", "0"))
sideKey2     := IniRead(IniFile, IniSect, "SideKey2", "Ctrl")
closeMax     := Number(IniRead(IniFile, IniSect, "CloseMAX", "0"))
closeStr     := Array()
iSyncPause   := Number(IniRead(IniFile, IniSect, "SyncPause", "0"))

iDebug       := Number(IniRead(IniFile, IniSect, "DEBUG_LOG", "0"))
iTrace       := Number(IniRead(IniFile, IniSect, "DEBUG_TRACE", "0"))
iDelete      := Number(IniRead(IniFile, IniSect, "DELETE_LOG", "1"))
iLogLine     := Number(IniRead(IniFile, IniSect, "DEBUG_LOG_LINE", "0"))
iLogSJIS     := Number(IniRead(IniFile, IniSect, "DEBUG_LOG_SJIS", "1"))
LOG_PATH     := "UtilsManagerLog.txt"
if( iDelete || iLogLine ){
	try{
		FileDelete(LOG_PATH)
	}
}
if( iDebug ){
	A_TrayMenu.Insert("3&", "Open LOG file", handleMenuItemLog)
	LogInit( "UtilsManager", LOG_PATH,, iLogSJIS,,, iLogLine )
	LogOutput("UtilsManager Start",,1)
	LogOutput("■Load Setting.",,1)
	LogOutput("topMostVNC=" topMostVNC " hideTaskBar=" hideTaskBar " buttonScroll=" buttonScroll,,1)
	LogOutput("sideChg1=" sideChg1 " sideKey1=" sideKey1 " sideChg2=" sideChg2 " sideKey2=" sideKey2,,1)
}

;//VNCクライアントで無視するタイトル(10定義までで固定)
ignoreTitle := Array()
idx := 1
Loop 10
{
	strTemp := IniRead(IniFile, IniSect, "IgnoreTitle" idx, "")
	if( strTemp != "" ){
		ignoreTitle.push(strTemp)
		if( iDebug ){
			LogOutput("IgnoreTitle[" idx "]=" strTemp,,1)
		}
	}
	idx++
}

;//トリガファイルとトリガ実行モジュール両方定義されていないと無効
iTrigger := Number(IniRead(IniFile, IniSect, "TriggerMax", "0"))
TriggerFile := Array()
TriggerExec := Array()
iStep := 0
idx := 1
Loop iTrigger
{
	strTemp1 := IniRead(IniFile, IniSect, "TriggerFile" idx, "")
	strTemp2 := IniRead(IniFile, IniSect, "TriggerExec" idx, "")
	if( strTemp1 != "" && strTemp2 != "" ){
		TriggerFile.push(strTemp1)
		TriggerExec.push(strTemp2)
		if( iDebug ){
			LogOutput("TriggerFile[" idx "]=" strTemp1 " TriggerExec[" idx "]=" strTemp2,,1)
		}
	}
	idx++
}
iTrigger := TriggerFile.Length


idx := 1

while( closeMax > 0 ){

	strTemp := ""
	;消去対象の読み込み(CLOSE1～)
	strTemp := IniRead(IniFile, IniSect, "CLOSE" String(idx), "")
	if( strTemp != "" ){
		closeStr.Push( strTemp )
		if( iDebug ){
			LogOutput("closeStr[" idx "]=" strTemp,,1)
		}
	}
	closeMax--
	idx++
}

if( iSyncPause ){
	OnMessage(MSG_SYNC_PAUSE, DoSyncPauseAction)
	if( iDebug ){
		LogOutput("OnMessage[MSG_SYNC_PAUSE] Listening Start.")
	}
}

DoSyncPauseAction(wParam, lParam, msg, hwnd){
	if( iSyncPause ){
		if( iDebug ){
			LogOutput("OnMessage[MSG_SYNC_PAUSE] val:" StrHex4(lParam) " from:" StrHex4(wParam) "(" gObj_SyncPauseAppList[wParam] ")")
		}
		return SyncPause( MY_APP_ID, lParam, 0, DEF_MENU)
	}
}





idx := 1
iTrgIdx := 1
lastWnd := 0
global hwndToolTips := 0

Loop
{
	;//トリガファイルがあったらトリガ実行する同居機能
	if( TriggerFile.Length ){
		if( iStep = 10 ){
			iTrgIdx := 1
			while( TriggerFile.Length >= iTrgIdx ){
				if( FileExist(TriggerFile[iTrgIdx]) && FileExist(TriggerExec[iTrgIdx]) ){
					try{
						;//各PCで同時に更新モジュール取得が走るのを避けるためランダムで1～10秒待つ
						Sleep(Random(1, 10) * 1000)
						FileDelete(TriggerFile[iTrgIdx])
						Run( A_ComSpec ' /c start "" ' TriggerExec[iTrgIdx] ,,"Hide" )
						if( iDebug ){
							LogOutput( "Trigger[" iTrgIdx "] : Delete " TriggerFile[iTrgIdx]
									 . " and Run " TriggerExec[iTrgIdx] " Complete." )
						}
					}catch{
						if( iDebug ){
							LogOutput( "Trigger[" iTrgIdx "] : Delete " TriggerFile[iTrgIdx]
									 . " or Run " TriggerExec[iTrgIdx] " Error." )
						}
					}
				}
				iTrgIdx++
			}
			iStep := 0
		}else{
			iStep++
		}
	}

	;//指定ウィンドウを自動的に閉じる機能
	idx := 1
	while( closeStr.Length >= idx ){
		try{
			WinClose( closeStr[idx] )
			if( iDebug ){
				LogOutput( "WinClose : [" idx "] " closeStr[idx] )
			}
		}
		idx++
	}
	
	;//VNCクライアントを最大化している仮想デスクトップに切り替わった後にタスクトレイに橙ハイライト状態で残るのを抑止する機能
	if( topMostVNC ){
		strTargetPath := ""
		strTargetTitle := ""
		try{
			MouseGetPos(&msX, &msY, &newWnd, &msCtrl, 1)
			if( hwndToolTips = newWnd && newWnd ){
				newWnd := lastWnd
				;//ここではフェードアウト無しで消去しないとすぐあとの生成処理とすれ違う
				;DeleteCustomToolTip()
				DestroyCustomToolTip(1)
				hwndToolTips := 0
			}
		}catch{
			msX := 0
			msY := 0
			newWnd := 0
			msCtrl := 0
			if( iDebug && iTrace ){
				LogOutput( "    MouseGetPos : Error." )
			}
		}
		if( newWnd != lastWnd && newWnd ){
			try{
				strTargetPath := WinGetProcessName("ahk_id " newWnd)
				if( strTargetPath != "vncviewer.exe" ){
					if( iDebug && iTrace ){
						LogOutput( "    DifferentTarget : " strTargetPath )
					}
					lastWnd := newWnd
					Sleep(LoopWait)
					continue
				}
				strTargetTitle := WinGetTitle("ahk_id " newWnd)
				iFindIgnore := 0
				iFindIdx := 1
				Loop ignoreTitle.Length
				{
					if( InStr(strTargetTitle,ignoreTitle[iFindIdx]) > 0 ){
						iFindIgnore := 1
						if( iDebug && iTrace ){
							LogOutput( "    FindIgnore : " strTargetPath " title=" strTargetTitle " Ignore[" iFindIdx "]=" ignoreTitle[iFindIdx] )
						}
					}
					iFindIdx++
				}
				iStyle := WinGetStyle("ahk_id " newWnd)
				;//strStyle := StrHex8(iStyle)
				;//VNCの設定コンテキストがF1やタイトルバー右クリックで出ている場合や設定画面や無視定義されている時は無視
				if( strTargetTitle = "" || strTargetTitle = "VNC Viewer - Options" || (iStyle & WS_POPUP) || iFindIgnore ){
					if( iDebug && iTrace ){
						LogOutput( "    UnmatchTarget : " strTargetPath " title=" strTargetTitle " style=" strHex8(iStyle) " Ignore=" iFindIgnore )
					}
					lastWnd := newWnd
					Sleep(LoopWait)
					continue
				}
				;//既にActiveであるならActivateしない
				if( WinActive("ahk_id " newWnd) = 0 ){
					WinActivate("ahk_id " newWnd)
					strTargetTitle := "■ " strTargetTitle
					if( iDebug ){
						LogOutput( strTargetTitle " (Activate)" )
					}
				}else{
					strTargetTitle := "□ " strTargetTitle
					if( iDebug ){
						LogOutput( strTargetTitle " (Aleady Active)" )
					}
				}
				;//消去処理が次回の生成と同じタイミングになるとエラーになるので先にタイマーをセットする事で前回タイマーをリセット
				SetTimer () => DeleteCustomToolTip(), -2500
				hwndToolTips := ShowCustomToolTip( strTargetTitle, A_ScreenWidth, 0, 1, "FFFFFF", "7F7F7F" )
			}catch TargetError{
				;//WinGet系の関数がすれ違いで獲得したハンドルのウィンドウが既に破棄されている場合など
				if( iDebug && strTargetPath != "" ){
					LogOutput( "TargetError : " strTargetPath )
				}else if( iDebug && iTrace ){
					LogOutput( "    TargetError : targetPath is null" )
				}

			}catch OSError{
				;//WinGet系の関数が権限により取得出来ない対象だった場合エラーコード5が返る
				if( iDebug && strTargetPath != "" ){
					LogOutput( "OSError : " strTargetPath )
				}else if( iDebug && iTrace ){
					LogOutput( "    OSError : targetPath is null" )
				}
			}catch as err{
				;//それ以外の例外は何が起きているのか把握するためにToolTipに表示する
				strMsg := Format("{1}: {2}.`n`nFile:`t{3}`nLine:`t{4}`nWhat:`t{5}`nStack:`n{6}"
						, type(err), err.Message, err.File, err.Line, err.What, err.Stack)
				;//消去処理が次回の生成と同じタイミングになるとエラーになるので先にタイマーをセットする事で前回タイマーをリセット
				SetTimer () => DeleteCustomToolTip(), -10000
				hwndToolTips := ShowCustomToolTip( "Caught Exception`n" strMsg, A_ScreenWidth, 0, 1 )
				if( iDebug ){
					LogOutput( "Error : " strTargetPath " [" err.Message "]" )
				}
			}
		}
		lastWnd := newWnd
	}
	Sleep(LoopWait)
}


;//カスタムツールチップをフェードアウト消去
DeleteCustomToolTip(){
	global hwndToolTips
	hwndToolTips := 0
	FadeoutCustomToolTip(1,255)
}


;//メニューからの呼び出し
handleMenuItemReload(ItemName, ItemPos, MyMenu){
	Reload
}

handleMenuItemEdit(ItemName, ItemPos, MyMenu){
	try {
		Run(IniFile)
	}
}

handleMenuItemStop(ItemName, ItemPos, MyMenu){
	SyncPause( MY_APP_ID, -1, iSyncPause, DEF_MENU )
}

handleMenuItemLog(ItemName, ItemPos, MyMenu){
	try {
		Run(LOG_PATH)
	}
}




;//タスクバーの有効無効切り替え機能
#HotIf hideTaskBar
^!LWin::
{
	SetTitleMatchMode(2)
	If(WinExist("ahk_class Shell_TrayWnd")){
		WinHide "ahk_class Shell_TrayWnd"
		if( iDebug ){
			LogOutput( "WinHide : ahk_class Shell_TrayWnd" )
		}
	}else{
		WinShow "ahk_class Shell_TrayWnd"
		if( iDebug ){
			LogOutput( "WinShow : ahk_class Shell_TrayWnd" )
		}
	}
}
#HotIf

;//キー操作でスクロール
#HotIf buttonScroll
^!Up::
{
	PostMessage( 0x0115, 2,,,"ahk_id " WinActive("A") )
	if( iDebug ){
		LogOutput( "CTRL+ALT+UP    : PostMessage : 0x0115, 2" )
	}
}
^!Down::
{
	PostMessage( 0x0115, 3,,,"ahk_id " WinActive("A") )
	if( iDebug ){
		LogOutput( "CTRL+ALT+DOWN  : PostMessage : 0x0115, 3" )
	}
}
^!Left::
{
	PostMessage( 0x0114, 2,,,"ahk_id " WinActive("A") )
	if( iDebug ){
		LogOutput( "CTRL+ALT+LEFT  : PostMessage : 0x0114, 2" )
	}
}
^!Right::
{
	PostMessage( 0x0114, 3,,,"ahk_id " WinActive("A") )
	if( iDebug ){
		LogOutput( "CTRL+ALT+RIGHT : PostMessage : 0x0114, 3" )
	}
}
#HotIf

;//5ボタンマウスのサイドボタンを置換
#HotIf sideChg1
XButton1::
{
	Send("{" sideKey1 " Down}")
	if( iDebug ){
		LogOutput( "XButton1 Down : Send : {" sideKey1 ", Down}" )
	}
}
XButton1 Up::
{
	Send("{" sideKey1 " Up}")
	if( iDebug ){
		LogOutput( "XButton1 Up   : Send : {" sideKey1 ", Up  }" )
	}
}
#HotIf

#HotIf sideChg2
XButton2::
{
	Send("{" sideKey2 " Down}")
	if( iDebug ){
		LogOutput( "XButton2 Down : Send : {" sideKey2 ", Down}" )
	}
}
XButton2 Up::
{
	Send("{" sideKey2 " Up}")
	if( iDebug ){
		LogOutput( "XButton2 Up   : Send : {" sideKey2 ", Up  }" )
	}
}
#HotIf


