﻿;//-----------------------------------------------------------------------------------------------------------------
;// SendKeyWindow.ahk[UTF-8] (2026/02/10 14:00)
;// for AutoHotKey v2.0.21 or later
;//
;// http://coltpythonkingcobra.g1.xrea.com/pseudoTweetdeck/
;//                                             @PseudoTwDk
;//-----------------------------------------------------------------------------------------------------------------
;//
;
; 指定のウィンドウにキーを送る
;    SendKeyWindow KeyCodes Target (AllowStyle) (DenyStyle) (DispError) (Debug)
;       KeyCodes
;          (キー送出モード : XXX_YYY[opt1][opt2][opt3]) ※[optN]は XXX_YYY の前に書いても後に書いても良い
;            修飾キー + "_" + 送出キーを送る ※修飾キーのみを送ることは出来ないのでキーをAltなどのキーワード
;            指定すること (http://ahkscript.github.io/ja/docs/v2/KeyList.htm) 区切りの "_"必須
;            修飾キー：SHIFT=S, CTRL=C, ALT=A 順不同で大文字小文字区別なし
;            送出キー：大文字小文字区別無し、AutoHotKeyのキー指定で{}内に記述するキー名
;            オプション指定 [NoAct]/[na] 送信先をアクティブ化しない
;            オプション指定 [ControlSend]/[cs] hWnd指定でキー送出するモード
;            オプション指定 [DownUp]/[du] 装飾キーをキープレスではなくキーダウンとキーアップを送出するモード
;              ex) CSAW_R : CTRL+SHIFT+ALT+WIN+R を送る
;              ex) C_C   : CTRL+C を送る
;              ex) _A    : A を送る
;              ex) C_C[NoAct][ControlSend][DownUp] : アクティブ化せず{Ctrl Down}{C}{Ctrl Up} を送る
;          (PostMessageモード : "iMessage,iWParam,iLParam")
;            両端を "" で囲みカンマ区切りで値を指定する
;            iMessage : WM_SYSCOMMAND などウィンドウメッセージの数値を指定(必須)
;                       ※WM_SYSCOMMANDのみ特例で文字列記述WM_SYSCOMMANDで0x112と解釈されます
;            iWParam :  SC_MINIMIZE などＷパラメータの数値を指定(省略可ですが殆どのWMで必須だったかと)
;            iLParam :  Ｗパラメータに付随するＬパラメータの数値を指定(省略可)
;       Target
;          ウィンドウ文字列/ahk_exe フルパス/ahk_class クラスID など両端""でAutoHotKey
;          独自のウィンドウ指定記述、現在アクティブなウィンドウを指定する場合は"A"
;          https://ahkscript.github.io/ja/docs/v2/misc/WinTitle.htm
;          対象ウィンドウのウィンドウスタイルは WS_VISIBLE ビットが有効で WS_DISABLED ビットが無効の
;          ものとしています。複数ウィンドウに該当する場合はエラー表示し処理しません。
;          マッチを正規表現で記述したい時は先頭に"REGEX:"を書きます
;          AutoHotKeyV2の正規表現文法は下記参照
;          https://ahkscript.github.io/ja/docs/v2/misc/RegEx-QuickRef.htm
;          ex) "ahk_exe C:\Program Files\Mozilla Firefox\firefox.exe"
;          ex) "ahk_exe C:\Program Files\Vivaldi\Application\vivaldi.exe ahk_class Chrome_WidgetWin_1"
;       AllowStyle
;          処理対象であるウィンドウスタイルのビット積(andをとってマスク自身になれば対象)の16進表記
;          省略された場合やdef/defaultと書かれた時は 0x10000000(WS_VISIBLE) が指定されたものとします
;          全てを対象外にしてしまう 0x00000000 は指定できません
;       DenyStyle
;          処理対象から除外するウィンドウスタイルのビット積(andをとって0になれば対象)の16進表記
;          省略された場合やdef/defaultと書かれた時は 0x08000000(WS_DISABLED) が指定されたものとします
;          全てを対象外にしてしまう 0xFFFFFFFF は指定できません
;       DispError
;          1/on/disp : 対象ウィンドウが見つからない時や複数ヒットした際のエラーダイアログを出す
;          [any] : 上記以外が指定されるか無指定ならエラー時にダイアログを出さない
;       DebugMode
;          1/on/debug : デバッグモードON
;          [any] : 上記以外が指定されるか無指定ならデバッグモードOFF
;

/* 同時に複数実行を許可する */
#SingleInstance Off

#WinActivateForce
/* 非表示のウィンドウも捜索対象としておかないと仮想デスクトップで動作しない */
DetectHiddenWindows True

WM_SYSCOMMAND := 0x112
SC_MINIMIZE := 0xF020
SC_MAXIMIZE := 0xF030
SC_RESTORE := 0xF120

#Include AhkCommon.ahk



/* コマンドオプション数チェック */
if( A_Args.Length < 2 ){
	DispUsage()
}

/* モードとウィンドウ指定 */
strKeys := StrReplace(A_Args[1],'"','')
strTarget := A_Args[2]
arg_regx := 2
if( StrUpper(SubStr(strTarget,1,6)) = "REGEX:" ){
	strTarget := TargetToREGEX(strTarget)
	arg_regx := "RegEx"
	strTarget := SubStr(strTarget,7)
}
UniqueID := 0
iDisp := 0
iDebug := 0
iAllowStyle := 0
iDenyStyle := 0xFFFFFFFF


/* 必須ウィンドウスタイルの扱い */
if( A_Args.Length >= 3 ){
	iAllowStyle := A_Args[3]
}
if( iAllowStyle = 0 || StrUpper(iAllowStyle) = "DEF" || StrUpper(iAllowStyle) = "DEFAULT" ){
	iAllowStyle := WS_VISIBLE
}else{
	iAllowStyle := StyleNumber(iAllowStyle,WS_VISIBLE)
}

/* 除外ウィンドウスタイルの扱い */
if( A_Args.Length >= 4 ){
	iDenyStyle := A_Args[4]
}
if( iDenyStyle = 0xFFFFFFFF || StrUpper(iDenyStyle) = "DEF" || StrUpper(iDenyStyle) = "DEFAULT" ){
	iDenyStyle := WS_DISABLED
}else{
	iDenyStyle := StyleNumber(iDenyStyle,WS_DISABLED)
}


/* エラーダイアログの扱い */
if( A_Args.Length >= 5 ){
	iDisp := A_Args[5]
}
if( iDisp = 1 || StrUpper(iDisp) = "ON" || StrUpper(iDisp) = "DISP" ){
	iDisp := 1
}else{
	iDisp := 0
}

/* デバッグモードの指定 */
if( A_Args.Length >= 6 ){
	iDebug := A_Args[6]
}
if( iDebug = 1 || StrUpper(iDebug) = "ON" || StrUpper(iDebug) = "DEBUG" ){
	iDebug := 1
	LogInit("SendKeyWindow","AutoHotKeyV2_debug_log.txt")
}else{
	iDebug := 0
}

if( iDebug ){
	LogOutput( "PATH=" strTarget " REGX=" arg_regx " Allow=" StrHex8(iAllowStyle) " Deny=" StrHex8(iDenyStyle) )
}

/* タイトルマッチモードの設定(2=部分一致, "RegEx"=正規表現) */
SetTitleMatchMode(arg_regx)

/* フルパスに合致するウィンドウを列挙(非表示ウィンドウも対象としているため沢山ヒットする) */
listWin := WinGetList(strTarget)
idxWin := 0
findCount := 0

/* ウィンドウスタイルでマスク */
for(hWin in listWin){
	idxWin := idxWin + 1
	try{
		style := WinGetStyle("ahk_id " hWin)
		if( iDebug ){
			LogOutput("Style=" StrHex8(style) " Allow=" StrHex8(iAllowStyle) " Deny=" StrHex8(iDenyStyle))
		}
		if( TestStyle( style, iAllowStyle, iDenyStyle, hWin ) ){
			findCount++
			UniqueID := hWin
		}
	}
}

if( UniqueID = 0 ){
	if( iDisp ){
		MsgBox(strTarget " not found.")
	}
	if( iDebug ){
		LogOutput(strTarget " not found.")
	}
	ExitApp(1)
}

if( findCount != 1 ){
	if( iDisp ){
		MsgBox(strTarget " has multiple windows.")
	}
	if( iDebug ){
		LogOutput(strTarget " has multiple windows.")
	}
	ExitApp(1)
}

/* 修飾キーと送出キーの解釈 */
if( InStr(strKeys, "_") ){

	iNoAct := 0
	iCtrlSend := 0
	iDownUp := 0
	
	strKeys := StrLower(strKeys)
	
	if( InStr(strKeys,"[noact]" ) || InStr(strKeys,"[na]" ) ){
		iNoAct := 1
		strKeys := StrReplace(strKeys,"[noact]","")
		strKeys := StrReplace(strKeys,"[na]","")
	}
	if( InStr(strKeys,"[controlsend]" ) || InStr(strKeys,"[cs]" ) ){
		iCtrlSend := 1
		strKeys := StrReplace(strKeys,"[controlsend]","")
		strKeys := StrReplace(strKeys,"[cs]","")
	}
	if( InStr(strKeys,"[downup]" ) || InStr(strKeys,"[du]" ) ){
		iDownUp := 1
		strKeys := StrReplace(strKeys,"[downup]","")
		strKeys := StrReplace(strKeys,"[du]","")
	}
	
	/* 修飾キー_送出キー モード */
	aryKeys := StrSplit(strKeys,"_")
	if( aryKeys.Length = 2 ){
		

		strExtKey := aryKeys[1]
		strSndKey := aryKeys[2]
		strTemp := ""
		strTempD := ""
		strTempU := ""

		if( InStr(strExtKey,"c") != 0 ){
			strTemp := strTemp "^"
			strTempD := strTempD "{Ctrl Down}"
			strTempU := "{Ctrl Up}" strTempU
		}
		if( InStr(strExtKey,"s") != 0 ){
			strTemp := strTemp "+"
			strTempD := strTempD "{Shift Down}"
			strTempU := "{Shift Up}" strTempU
		}
		if( InStr(strExtKey,"a") != 0 ){
			strTemp := strTemp "!"
			strTempD := strTempD "{Alt Down}"
			strTempU := "{Alt Up}" strTempU
		}
		if( InStr(strExtKey,"w") != 0 ){
			strTemp := strTemp "#"
			strTempD := strTempD "{LWin Down}"
			strTempU := "{LWin Up}" strTempU
		}
		if( SubStr(strSndKey,1,1) = "f" && IsNumber(StrReplace(strSndKey,"f","")) ){
			strSndKey := StrUpper(strSndKey)
		}
		strSndKey := "{" strSndKey "}"

		try{
			if( ! iNoAct ){
				WinActivate("ahk_id " UniqueID)
				if( iDebug ){
					LogOutput("Send Key : WinActivate hWnd[" UniqueID "]")
				}
			}
			if( ! iCtrlSend ){
				if( ! iDownUp ){
					Send(strTemp strSndKey)
					if( iDebug ){
						LogOutput("Send Key : Type1 Send " strTemp strSndKey)
					}
				}else{
					Send(strTempD strSndKey strTempU)
					if( iDebug ){
						LogOutput("Send Key : Type2 Send " strTempD "+" strSndKey "+" strTempU)
					}
				}
			}else{
				if( ! iDownUp ){
					ControlSend(strTemp strSndKey,, "ahk_id " UniqueID)
					if( iDebug ){
						LogOutput("Send Key : Type3 ControlSend " strTemp strSndKey " hWnd[" UniqueID "]")
					}
				}else{
					ControlSend(strTempD strSndKey strTempU,, "ahk_id " UniqueID)
					if( iDebug ){
						LogOutput("Send Key : Type4 ControlSend " strTempD "+" strSndKey "+" strTempU " hWnd[" UniqueID "]")
					}
				}
			}
		}catch TargetError as err{
			if( iDisp ){
				MsgBox("WinActivate Error.")
			}
			if( iDebug ){
				LogOutput("WinActivate Error.")
			}
			ExitApp(1)
		}
	}else{
		DispUsage()
	}
/*
	aryKeys := StrSplit(StrLower(strKeys),"_")
	if( aryKeys.Length = 2 ){

		strExtKey := aryKeys[1]
		strSndKey := aryKeys[2]
		strTemp := ""

		if( InStr(strExtKey,"c") != 0 ){
			strTemp := strTemp "^"
		}
		if( InStr(strExtKey,"s") != 0 ){
			strTemp := strTemp "+"
		}
		if( InStr(strExtKey,"a") != 0 ){
			strTemp := strTemp "!"
		}
		if( SubStr(strSndKey,1,1) = "f" && IsNumber(StrReplace(strSndKey,"f","")) ){
			strSndKey := StrUpper(strSndKey)
		}
		strTemp := strTemp "{" strSndKey "}"

		try{
			WinActivate("ahk_id " UniqueID)
			Send(strTemp)
			if( iDebug ){
				LogOutput("Send Key : " strTemp)
			}
		}catch TargetError as err{
			if( iDisp ){
				MsgBox("WinActivate Error.")
			}
			if( iDebug ){
				LogOutput("WinActivate Error.")
			}
			ExitApp(1)
		}
	}else{
		DispUsage()
	}
*/

}else{

	/* PostMessageモード */
	strKeys := StrReplace(strKeys, ' ', "")
	aryTemp := StrSplit(strKeys, ",")

	;MsgBox( aryTemp.Length )
	aryTemp[1] := StrReplace(aryTemp[1], "WM_SYSCOMMAND", "0x112")

	try{
		if( aryTemp.Length = 1 ){
			PostMessage( Number(aryTemp[1]),,,, "ahk_id " UniqueID)
			if( iDebug ){
				LogOutput("PostMessage: (" Number(aryTemp[1]) ")" )
			}
		}else if( aryTemp.Length = 2 ){
			PostMessage( Number(aryTemp[1]), Number(aryTemp[2]),,, "ahk_id " UniqueID)
			if( iDebug ){
				LogOutput("PostMessage: (" Number(aryTemp[1]) ", " Number(aryTemp[2]) ")" )
			}
		}else if( aryTemp.Length = 3 ){
			PostMessage( Number(aryTemp[1]), Number(aryTemp[2]), Number(aryTemp[3]),, "ahk_id " UniqueID)
			if( iDebug ){
				LogOutput("PostMessage: (" Number(aryTemp[1]) ", " Number(aryTemp[2]) ", " Number(aryTemp[3]) ")" )
			}
		}else{
			DispUsage()
		}
	}catch{
		DispUsage()
	}
}

ExitApp(0)

DispUsage(){
	msg := 'Usage:`n'
	msg := msg 'SendKeyWindow.exe KeyCodes Target (...options)`n`n'
	msg := msg '[KeyCodes]`n'
	msg := msg '    ex) CSAW_R = CTRL+SHIFT+ALT+WIN+R`n'
	msg := msg '    ex) CS_T = CTRL+SHIFT+T`n'
	msg := msg '    ex) C_A = CTRL+A`n'
	msg := msg '    ex) _X = X`n'
	msg := msg '    ex) C_F5[NoAct][ControlSend][DownUp] `n'
	msg := msg '        = Use hWnd{Ctrl Down}{F5}{Ctrl Up}`n'
	msg := msg '    ex) "0x112,0xF020,0x0000"'
	msg := msg '        = PostMesage(iMsg,iWParam,iLParam)`n'
	msg := msg '[Target]`n'
	msg := msg '   "window-title / REGEX:match-title-str`n'
	msg := msg '    ahk_exe full-path`n'
	msg := msg '    ahk_class class-name..."`n'
	msg := msg '[AllowStyle]`n'
	msg := msg '    enabled WindowStyle Bits`n'
	msg := msg '    def/default = 0x10000000(WS_VISIBLE)`n'
	msg := msg '    ex) 0x16C70000`n'
	msg := msg '[DenyStyle]`n'
	msg := msg '    disabled WindowStyleBits`n'
	msg := msg '    def/default = 0x08000000(WS_DISABLED)`n'
	msg := msg '    ex) 0xE8000000`n'
	msg := msg '[DispError]`n'
	msg := msg '    1/on/disp = display ErrorDialog`n'
	msg := msg '[DebugMode]`n'
	msg := msg '    1/on/debug = Debug mode`n'
	MsgBox(msg)
	ExitApp(1)
}


