﻿;//-----------------------------------------------------------------------------------------------------------------
;// ScreenSaver.ahk[UTF-8] (2026/02/19 17:30)
;// for AutoHotKey v2.0.21 or later
;//
;// http://coltpythonkingcobra.g1.xrea.com/pseudoTweetdeck/
;//                                             @PseudoTwDk
;//-----------------------------------------------------------------------------------------------------------------
;//
;//
;// リモート接続されるサーバ側ではディスプレイの電源をOFFにしたりスクリーンセーバーを
;// 起動したりといった事が抑止されています。そのため自前の判定によってセーバーを起動
;// するものです。
;//
;// 使い方
;//  各種パラメータはiniファイルに記述します
;//
;// マウスが動かない時間が一定時間以上になったらスクリーンセーバーを起動します。
;// 途中でマウスが動くと中断し、また一定時間操作されないと動作を再開します。
;//
;// クリックやキー入力は無視されマウスの移動だけで判定しています。
;//
;// マウスカーソルが左下にある時以外は起動しません。
;// 設定したウィンドウがアクティブな時以外は起動しません。
;//
;// 他のウィンドウ操作系ツールと違い、仮想デスクトップ上で他のデスクトップにあるウィンドウ
;// は対象としていないためウィンドウスタイルによる絞り込みなどは行っていません。
;//

;//多重起動時ダイアログボックスをスキップして既存インスタンスを終了させ新しいインスタンスを起動
#SingleInstance Force

;@Ahk2Exe-AddResource ScreenSaver.ico, 1
;@Ahk2Exe-AddResource ScreenSaver2.ico, 2
TraySetIcon(,,true)
try{
	TraySetIcon(A_ScriptFullPath,1)
}catch{
	TraySetIcon("ScreenSaver.ico")
}
IniFile      := "ScreenSaver.ini"
IniSect      := "APP"

#Include AhkCommon.ahk


;//MouseGetPosはスクリーンを対象とする
CoordMode("Mouse", "Screen")

;//タスクトレイアイコンにメニュー項目追加
A_TrayMenu.Insert("1&", "ExecForce after 5sec", handleMenuItemStart)
A_TrayMenu.Insert("2&", "Reload ScreenSaver", handleMenuItemReload)
A_TrayMenu.Insert("3&", "Edit INI file", handleMenuItemEdit)
A_TrayMenu.Insert("4&", "Pause and Suspend", handleMenuItemStop)
A_TrayMenu.Delete("6&")
A_TrayMenu.Delete("5&")

MY_APP_ID := APP_SCREENSAVER
DEF_MENU := "ExecForce after 5sec"
A_TrayMenu.Default := DEF_MENU
A_TrayMenu.ClickCount := 1


;//変数初期化
Path         := Array()
Regx         := Array()
noDialog     := Number(IniRead(IniFile, IniSect, "NoDialog", "0"))
pastMin      := Number(IniRead(IniFile, IniSect, "SaverTime", "30"))
saverPath    := IniRead(IniFile, IniSect, "SaverPath", "")
ExecForce    := Number(IniRead(IniFile, IniSect, "ExecForce", "0"))
enableKey1   := Number(IniRead(IniFile, IniSect, "EnableKey", "0"))
enableKey2   := Number(IniRead(IniFile, IniSect, "EnableKey2", "0"))
POS_LIMIT    := Number(IniRead(IniFile, IniSect, "PosLimit", "5"))
X_LIMIT      := Number(IniRead(IniFile, IniSect, "X_LIMIT", "500"))
Y_LIMIT      := Number(IniRead(IniFile, IniSect, "Y_LIMIT", "600"))
iSyncPause   := Number(IniRead(IniFile, IniSect, "SyncPause", "0"))
iSyncStart   := Number(IniRead(IniFile, IniSect, "SyncStart", "0"))

global lastTime  := A_Now
global lastX     := -1
global lastY     := -1
global modeActive:= 0 ;//1=マウスが動いてる, 0=一定時間以上止まっている
saverGUI     := 0
saverFileName:= ""
try{
	SplitPath( saverPath, &saverFileName )
}
targetLog    := ""

;iniファイルから件数を読み込む
count := IniRead(IniFile, IniSect, "MAX", 0)
if( count = 0 ){
	MsgBox("iniファイルに定義がありません")
	ExitApp()
}

iDebug     := Number(IniRead(IniFile, IniSect, "DEBUG_LOG", "0"))
iDelete    := Number(IniRead(IniFile, IniSect, "DELETE_LOG", "1"))
iLogLine   := Number(IniRead(IniFile, IniSect, "DEBUG_LOG_LINE", "0"))
iLogSJIS   := Number(IniRead(IniFile, IniSect, "DEBUG_LOG_SJIS", "1"))
LOG_PATH   := "ScreenSaverLog.txt"
if( iDelete || iLogLine ){
	try{
		FileDelete(LOG_PATH)
	}
}
if( iDebug ){
	A_TrayMenu.Insert("4&", "Open LOG file", handleMenuItemLog)
	LogInit( "ScreenSaver", LOG_PATH,, iLogSJIS,,, iLogLine)
	LogOutput("ScreenSaver Start",,1)
	LogOutput("■Load Setting.",,1)
	LogOutput("PastMin=" pastMin " ExexForce=" ExecForce " POS_LIMIT=" POS_LIMIT " X_LIMIT= " X_LIMIT " Y_LIMIT=" Y_LIMIT,,1)
}


idx := 1
while( count > 0 ){
	;//フルパスの読み込み(PATH1～)
	strTemp := IniRead(IniFile, IniSect, "PATH" String(idx), "")
	arg_regx := 2
	if( StrUpper(SubStr(strTemp,1,6)) = "REGEX:" ){
		strTemp := TargetToREGEX(strTemp)
		arg_regx := "RegEx"
		strTemp := SubStr(strTemp,7)
	}

	if( iDebug ){
		LogOutput("Target [" StrNum2(idx) "] Path=" REGEXToTarget(strTemp) " RegEx=" arg_regx,,1)
	}
	Path.Push( strTemp )
	Regx.Push( arg_regx )

	count--
	idx++
}


if(! noDialog){
	MsgBox("スクリーンセーバーの常駐を開始します",,"0x40040 T5")
}

;//プロセス間通信
if( iSyncPause ){
	OnMessage(MSG_SYNC_PAUSE, DoSyncPauseAction)
	if( iDebug ){
		LogOutput("OnMessage[MSG_SYNC_PAUSE] Listening Start.")
	}
}

DoSyncPauseAction(wParam, lParam, msg, hwnd){
	if( iSyncPause ){
		if( iDebug ){
			LogOutput("OnMessage[MSG_SYNC_PAUSE] val:" StrHex4(lParam) " from:" StrHex4(wParam) "(" gObj_SyncPauseAppList[wParam] ")")
		}
		return SyncPause( MY_APP_ID, lParam, 0, DEF_MENU )
	}
}

if( iSyncStart ){
	OnMessage(MSG_SYNC_START, DoSyncStartAction)
	if( iDebug ){
		LogOutput("OnMessage[MSG_SYNC_START] Listening Start.")
	}
}

DoSyncStartAction(wParam, lParam, msg, hwnd){
	if( iSyncStart ){
		if( iDebug ){
			LogOutput("OnMessage[MSG_SYNC_START] val:" StrHex4(lParam) " from:" StrHex4(wParam) "(" gObj_SyncStartAppList[wParam] ")")
		}
		return SyncStart( MY_APP_ID, 0, execAfterWait )
	}
}

;//スクリプト終了時にカーソルが表示されるようにする
OnExit (*) => SystemCursor("Show")

;//座標を獲得して前回値と比較する */
Loop{
	try {
		MouseGetPos( &posX, &posY, &posWin, &posCtrl )
		if( Abs(posX - lastX) > POS_LIMIT || Abs(posY - lastY) > POS_LIMIT ){
			lastX := posX
			lastY := posY
			lastTime := A_Now
			modeActive := 1
			if( saverGUI ){
				saverGUI.Destroy()
				saverGUI  := 0
				SystemCursor("Show")
				if( iDebug ){
					LogOutput("Move : Abort saver GUI" )
				}
			}
		}else{
			modeActive := 0
		}
		past := DateDiff( A_Now, lastTime, "Seconds" )
		if( (past > pastMin * 60) && (posX < X_LIMIT) && (posY > Y_LIMIT) && modeActive = 0 && isTarget() ){
			if( execSaver() ){
				if( iDebug ){
					LogOutput("Past : " past " / " targetLog )
				}
			}
		}
		;ToolTip( "past=" past " pos=(" posX "," posY ")",,,1)
	} catch Error as err {
		;
	}
	Sleep(100)
}


;//セーバーを起動する
execSaver(){
	global saverGUI
	try {
		if( saverPath != "" ){
			if( ! ProcessExist(saverFileName) ){
				Run(saverPath " /s")
				if( iDebug ){
					LogOutput("Start ScreenSaver : " saverFileName )
				}
				return 1
			}
		}else{
			if( ! saverGUI ){
				saverGUI := Gui()
				saverGUI.Opt("+AlwaysOnTop -Caption -SysMenu -ToolWindow +Owner")
				saverGUI.BackColor := 0
				saverGUI.Show("Maximize")
				saverGUI.Title := "CustomScreenSaver"
				SystemCursor("Hide")
				if( iDebug ){
					LogOutput("Start saver GUI")
				}
				return 1
			}else{
				WinMoveTop("ahk_id " saverGUI.Hwnd)
			}
		}
		
	} catch Error as err {
		MsgBox( "ScreenSaver exec error.", , "0x40010 T10")
		ExitApp()
	}
	return 0
}

;//セーバー起動対象のウィンドウかどうかを判定
isTarget(){
	global targetLog
	if(ExecForce){
		return 1
	}
	idx := 1
	while( Path.Length >= idx ){
		;//タイトルマッチモードの設定(2=部分一致, "RegEx"=正規表現)
		SetTitleMatchMode( Regx[idx] )

		if( WinActive(Path[idx]) ){
			if( iDebug ){
				targetLog := "isTarget : idx=" StrNum2(idx) " Path=" REGEXToTarget(Path[idx]) " Regx=" Regx[idx]
			}
			return 1
		}
		idx := idx + 1
	}
	if( iDebug ){
		targetLog := ""
	}
	return 0
}

;//メニューからの呼び出し
handleMenuItemStart(ItemName, ItemPos, MyMenu){
	if( iDebug ){
		LogOutput("Exec from Menu" )
	}
	SyncStart( MY_APP_ID, iSyncStart, execAfterWait )
}

handleMenuItemReload(ItemName, ItemPos, MyMenu){
	Reload
}

handleMenuItemEdit(ItemName, ItemPos, MyMenu){
	try {
		Run(IniFile)
	}
}

handleMenuItemStop(ItemName, ItemPos, MyMenu){
	if( iDebug ){
		LogOutput("Pause from Menu" )
	}
	SyncPause( MY_APP_ID, -1, iSyncPause, DEF_MENU )
}

handleMenuItemLog(ItemName, ItemPos, MyMenu){
	try {
		Run(LOG_PATH)
	}
}


;//手動で開始する
execAfterWait(){
	
	if(! noDialog){
		MsgBox("スクリーンセーバーを５秒後に開始します",,"0x40040 T5")
	}else{
		Sleep(5000)
	}
	;//すぐ停止しないようにする
	global lastTime,lastX,lastY
	try {
		MouseGetPos( &posX, &posY, &posWin, &posCtrl )
		lastX := posX
		lastY := posY
		lastTime := DateAdd( A_Now, -1 * pastMin * 60, "Seconds" )
	}
	execSaver()
}

#HotIf enableKey1
	;//SHIFT+Z でセーバーの起動
	+Z::
	{
		if( iDebug ){
			LogOutput("Exec from SHIFT+Z" )
		}
		execAfterWait()
	}
#HotIf enableKey2
	;//CTRL+SHIFT+Z でセーバーの起動
	^+Z::
	{
		if( iDebug ){
			LogOutput("Exec from CTRL+SHIFT+Z" )
		}
		execAfterWait()
	}
#HotIf

