﻿;//-----------------------------------------------------------------------------------------------------------------
;// ResizeBrowser.ahk[UTF-8] (2026/02/21 15:00)
;// for AutoHotKey v2.0.21 or later
;//
;// http://coltpythonkingcobra.g1.xrea.com/pseudoTweetdeck/
;//                                             @PseudoTwDk
;//-----------------------------------------------------------------------------------------------------------------
;//
;//
;// 何故か位置やサイズが微妙に変わっていってしまうブラウザが前面に来た時に位置と
;// サイズを規定値に戻します。
;//
;// 使い方
;//  各種パラメータはiniファイルに記述します
;//

;//多重起動時ダイアログボックスをスキップして既存インスタンスを終了させ新しいインスタンスを起動
#SingleInstance Force

;@Ahk2Exe-AddResource ResizeBrowser.ico, 1
;@Ahk2Exe-AddResource ResizeBrowser2.ico, 2
TraySetIcon(,,true)
try{
	TraySetIcon(A_ScriptFullPath,1)
}catch{
	TraySetIcon("ResizeBrowser.ico")
}
IniFile := "ResizeBrowser.ini"
IniSect := "APP"

#Include AhkCommon.ahk


;//MouseGetPosはスクリーンを対象とする
CoordMode("Mouse", "Screen")

;//タスクトレイアイコンにメニュー項目追加
A_TrayMenu.Insert("1&", "Reload ResizeBrowser", handleMenuItemReload)
A_TrayMenu.Insert("2&", "Force Resize and Position", handleMenuItemForce)
A_TrayMenu.Insert("3&", "Edit INI file", handleMenuItemEdit)
A_TrayMenu.Insert("4&", "Pause and Suspend", handleMenuItemStop)
A_TrayMenu.Delete("6&")
A_TrayMenu.Delete("5&")

MY_APP_ID := APP_RESIZEBROWSER
DEF_MENU := "Pause and Suspend"
A_TrayMenu.Default := DEF_MENU
A_TrayMenu.ClickCount := 1


;//変数初期化
lastWnd := 0
Path := Array()
Regx := Array()
PosSize := Array()
ForceMove := Array()
Out := Array()

;//左上座標とサイズを格納する配列の添字
POSX := 1
POSY := 2
SIZW := 3
SIZH := 4
;//四隅座標の値を格納する配列の添字
LTX := 5
LTY := 6
RTX := 7
RTY := 8
LBX := 9
LBY := 10
RBX := 11
RBY := 12
;//配列の要素数を伸張
Out.Length := 12

;//iniファイルから件数を読み込む
count := IniRead(IniFile, IniSect, "MAX", 0)
if( count = 0 ){
	MsgBox("iniファイルに定義がありません")
	ExitApp()
}

iDebug     := Number(IniRead(IniFile, IniSect, "DEBUG_LOG", "0"))
iDelete    := Number(IniRead(IniFile, IniSect, "DELETE_LOG", "1"))
iLogLine   := Number(IniRead(IniFile, IniSect, "DEBUG_LOG_LINE", "0"))
iLogSJIS   := Number(IniRead(IniFile, IniSect, "DEBUG_LOG_SJIS", "1"))
LOG_PATH   := "ResizeBrowserLog.txt"
if( iDelete || iLogLine ){
	try{
		FileDelete(LOG_PATH)
	}
}
if( iDebug ){
	A_TrayMenu.Insert("4&", "Open LOG file", handleMenuItemLog)
	LogInit( "ResizeBrowser", LOG_PATH,, iLogSJIS,,, iLogLine )
	LogOutput("ResizeBrowser Start",,1)
	LogOutput("■Load Setting.",,1)
}

MoveWait   := Number(IniRead(IniFile, IniSect, "MoveWait", "1000"))
NextWait   := Number(IniRead(IniFile, IniSect, "NextWait", "10"))
LoopWait   := Number(IniRead(IniFile, IniSect, "LoopWait", "100"))
MoveLimit  := Number(IniRead(IniFile, IniSect, "MoveLimit", "100"))
iSyncPause := Number(IniRead(IniFile, IniSect, "SyncPause", "0"))

idx := 1
while( count > 0 ){

	strTemp := ""

	;//フルパスの読み込み(PATH1～)
	strTemp := IniRead(IniFile, IniSect, "PATH" String(idx), "")
	arg_regx := 2
	if( StrUpper(SubStr(strTemp,1,6)) = "REGEX:" ){
		strTemp := TargetToREGEX(strTemp)
		arg_regx := "RegEx"
		strTemp := SubStr(strTemp,7)
	}
	Path.Push( strTemp )
	Regx.Push( arg_regx )

	;//座標とサイズを読み込み(WIND1～)
	strTemp := IniRead(IniFile, IniSect, "WIND" String(idx), "")
	;//両端のダブルクォートを削除し、カンマ区切りを配列に分割
	strTemp := StrReplace(strTemp, '"', "")
	aryTemp := StrSplit(strTemp, ",")
	;//座標とサイズを数値化
	aryTemp[POSX] := Number(aryTemp[POSX])
	aryTemp[POSY] := Number(aryTemp[POSY])
	aryTemp[SIZW] := Number(aryTemp[SIZW])
	aryTemp[SIZH] := Number(aryTemp[SIZH])
	;//左上
	aryTemp.Push(aryTemp[POSX])
	aryTemp.Push(aryTemp[POSY])
	;//右上
	aryTemp.Push(aryTemp[POSX] + aryTemp[SIZW])
	aryTemp.Push(aryTemp[POSY])
	;//左下
	aryTemp.Push(aryTemp[POSX])
	aryTemp.Push(aryTemp[POSY] + aryTemp[SIZH])
	;//右下
	aryTemp.Push(aryTemp[POSX] + aryTemp[SIZW])
	aryTemp.Push(aryTemp[POSY] + aryTemp[SIZH])

	PosSize.Push( aryTemp )

	;//強制移動モード設定を読み込む
	iTemp := Number(IniRead(IniFile, IniSect, "MOVE" String(idx), "0"))
	ForceMove.Push(iTemp)

	if( iDebug ){
		LogOutput("Target [" StrNum2(idx) "] :"
				 . " PosSize(" aryTemp[POSX] "," aryTemp[POSY] "," aryTemp[SIZW] "," aryTemp[SIZH] ")"
				 . " LT(" aryTemp[LTX] "," aryTemp[LTY] ")"
				 . " RT(" aryTemp[RTX] "," aryTemp[RTY] ")"
				 . " LB(" aryTemp[LBX] "," aryTemp[LBY] ")"
				 . " RB(" aryTemp[RBX] "," aryTemp[RBY] ")"
				 . " Path=" REGEXToTarget(Path[idx]) " RegEx=" Regx[idx] " Force=" ForceMove[idx] ,,1)
	}

	count--
	idx++
}

;//プロセス間通信
if( iSyncPause ){
	OnMessage(MSG_SYNC_PAUSE, DoSyncPauseAction)
	if( iDebug ){
		LogOutput("OnMessage[MSG_SYNC_PAUSE] Listening Start.")
	}
}

DoSyncPauseAction(wParam, lParam, msg, hwnd){
	if( iSyncPause ){
		if( iDebug ){
			LogOutput("OnMessage[MSG_SYNC_PAUSE] val:" StrHex4(lParam) " from:" StrHex4(wParam) "(" gObj_SyncPauseAppList[wParam] ")")
		}
		return SyncPause( MY_APP_ID, lParam, 0, DEF_MENU)
	}
}





idx := 1
iTrgIdx := 1

;//順次アクティブウィンドウかどうかを切り替えて位置補正
Loop
{
	while( Path.Length >= idx ){

		;//タイトルマッチモードの設定(2=部分一致, "RegEx"=正規表現)
		SetTitleMatchMode( Regx[idx] )

		hWnd := WinActive( Path[idx] )
		if( hWnd != 0 ){
			;//最大化状態と最小化状態では動作させない
			MinMax := -1
			try{
				MinMax := WinGetMinMax( "ahk_id " hWnd )
			} catch Error as err {
				hWnd := 0
			}
			;//マウスのドラッグ操作中やスクロール中は動作させない
			IsDown1 := GetKeyState("LButton") || GetKeyState("RButton") || GetKeyState("MButton")
			IsDown2 := GetKeyState("WheelUp") || GetKeyState("WheelDown") || GetKeyState("WheelLeft") || GetKeyState("WheelRight")
			if( MinMax = 0 && IsDown1 = 0 && IsDown2 = 0 && hWnd != 0 ){
				;//現在のウィンドウ位置とサイズを獲得し、閾値未満のずれがあったら定位置定サイズに戻す
				try{
					WinGetPos( &OutX, &OutY, &OutW, &OutH, "ahk_id " hWnd )
				} catch Error as err {
					hWnd := 0
					OutX := 0
					OutY := 0
					OutW := 0
					OutH := 0
				}
				Out[POSX] := OutX
				Out[POSY] := OutY
				Out[SIZW] := OutW
				Out[SIZH] := OutH
				;//起点座標とサイズから四隅座標を求める
				Out[LTX] := Out[POSX]
				Out[LTY] := Out[POSY]
				Out[RTX] := Out[POSX] + Out[SIZW]
				Out[RTY] := Out[POSY]
				Out[LBX] := Out[POSX]
				Out[LBY] := Out[POSY] + Out[SIZH]
				Out[RBX] := Out[POSX] + Out[SIZW]
				Out[RBY] := Out[POSY] + Out[SIZH]
				
				;//全座標が閾値以内にあり、どれか一致していない場合のみ対象とする
				if((Abs(Out[LTX] - PosSize[idx][LTX]) < MoveLimit &&
					Abs(Out[LTY] - PosSize[idx][LTY]) < MoveLimit &&
					Abs(Out[RTX] - PosSize[idx][RTX]) < MoveLimit &&
					Abs(Out[RTY] - PosSize[idx][RTY]) < MoveLimit &&
					Abs(Out[LBX] - PosSize[idx][LBX]) < MoveLimit &&
					Abs(Out[LBY] - PosSize[idx][LBY]) < MoveLimit &&
					Abs(Out[RBX] - PosSize[idx][RBX]) < MoveLimit &&
					Abs(Out[RBY] - PosSize[idx][RBY]) < MoveLimit &&
					!( Out[LTX] = PosSize[idx][LTX] && Out[LTY] = PosSize[idx][LTY] &&
					   Out[RTX] = PosSize[idx][RTX] && Out[RTY] = PosSize[idx][RTY] &&
					   Out[LBX] = PosSize[idx][LBX] && Out[LBY] = PosSize[idx][LBY] &&
					   Out[RBX] = PosSize[idx][RBX] && Out[RBY] = PosSize[idx][RBY] ) || ForceMove[idx]
					) && hWnd != 0 ){
					
					if( iDebug ){
						LogOutput("Change [" StrNum2(idx) "] :"
								 . " PosSize(" Out[POSX] "," Out[POSY] "," Out[SIZW] "," Out[SIZH] ")"
								 . " LTd(" Out[LTX] - PosSize[idx][LTX] "," Out[LTY] - PosSize[idx][LTY] ")"
								 . " RTd(" Out[RTX] - PosSize[idx][RTX] "," Out[RTY] - PosSize[idx][RTY] ")"
								 . " LBd(" Out[LBX] - PosSize[idx][LBX] "," Out[LBY] - PosSize[idx][LBY] ")"
								 . " RBd(" Out[RBX] - PosSize[idx][RBX] "," Out[RBY] - PosSize[idx][RBY] ")"
								 . " Limit=" MoveLimit " Force=" ForceMove[idx] )
					}
					
					Style := 0
					try{
						Style := WinGetStyle( "ahk_id " hWnd )
					} catch Error as err {
						hWnd := 0
					}
					if( (Style & WS_SIZEBOX) && !(Style & WS_POPUP) && hWnd != 0 ){

						;//サイズ変更可能なウィンドウでポップアップでない場合のみ移動リサイズする
						;MsgBox( Format( "0x{1:x}", Style ) )
						try{
							WinMove( PosSize[idx][1], PosSize[idx][2], PosSize[idx][3], PosSize[idx][4], "ahk_id " hWnd )
							if( iDebug ){
								LogOutput("WinMove : "
										 . "(" PosSize[idx][1] "," PosSize[idx][2] "," PosSize[idx][3] "," PosSize[idx][4] ")"
										 . " idx=" StrNum2(idx) " Path=" REGEXToTarget(Path[idx]) " RegEx=" Regx[idx]
										 . " Style=" StrHex8(Style) )
							}
						} catch Error as err {
							;
						}
						Sleep(MoveWait)

					}else if( ForceMove[idx] && hWnd != 0){

						;//強制移動の場合サイズ変更なしで中央座標を基準に移動する
						try{
							WinMove( PosSize[idx][1] - Out[SIZW]/2, PosSize[idx][2] - Out[SIZH]/2,,, "ahk_id " hWnd )
							if( iDebug ){
								LogOutput("WinMove[Force] : "
										 . "(" PosSize[idx][1] - Out[SIZW]/2 "," PosSize[idx][2] - Out[SIZH]/2 ")"
										 . " idx=" StrNum2(idx) " Path=" REGEXToTarget(Path[idx]) " RegEx=" Regx[idx]
										 . " Style=" StrHex8(Style) )
							}
						} catch Error as err {
							;
						}
						Sleep(MoveWait)
					}
				}
			}
		}

		idx++
		Sleep(NextWait)
	}
	
	idx := 1
	Sleep(LoopWait)
}



;//メニューからの呼び出し
handleMenuItemReload(ItemName, ItemPos, MyMenu){
	Reload
}

handleMenuItemEdit(ItemName, ItemPos, MyMenu){
	try {
		Run(IniFile)
	}
}

handleMenuItemStop(ItemName, ItemPos, MyMenu){
	SyncPause( MY_APP_ID, -1, iSyncPause, DEF_MENU )
}

handleMenuItemLog(ItemName, ItemPos, MyMenu){
	try {
		Run(LOG_PATH)
	}
}

;//移動量に関係無く定義座標サイズに強制的に戻す
handleMenuItemForce(ItemName, ItemPos, MyMenu){
	
	idx := 1
	while( Path.Length >= idx ){
		;//タイトルマッチモードの設定(2=部分一致, "RegEx"=正規表現)
		SetTitleMatchMode( Regx[idx] )

		hWnd := 0
		listWin := WinGetList( Path[idx] )
		
		if( listWin.length > 0 ){
			
			idxWin := 0
			for(hTgtW in listWin){
				idxWin++
				if( hTgtW != 0 ){
					style := 0
					try{
						style := WinGetStyle("ahk_id " hTgtW)
					}
					if( TestStyle( style, WS_BROWSER_ALLOW, WS_BROWSER_DENY ) ){
						try{
							WinMove( PosSize[idx][1], PosSize[idx][2], PosSize[idx][3], PosSize[idx][4], "ahk_id " hTgtW )
							if( iDebug ){
								LogOutput("WinMove(Force) : "
										 . "(" PosSize[idx][1] "," PosSize[idx][2] "," PosSize[idx][3] "," PosSize[idx][4] ")"
										 . " idx=" StrNum2(idx) " Path=" REGEXToTarget(Path[idx]) " RegEx=" Regx[idx]
										 . " Style=" StrHex8(Style) )
							}
						} catch Error as err {
							;
						}
					}
				}
			}
		}
		idx++
	}
}

