﻿;//-----------------------------------------------------------------------------------------------------------------
;// OpenWithLite.ahk[UTF-8] (2026/02/19 23:00)
;// for AutoHotKey v2.0.21 or later
;//
;// http://coltpythonkingcobra.g1.xrea.com/pseudoTweetdeck/
;//                                             @PseudoTwDk
;//-----------------------------------------------------------------------------------------------------------------
;//
;
; Open In Firefox Browser/Open In Chrome Browser /External Application Launcher から中継起動されるランチャ
; ※似た名前のAddOn/拡張機能が存在しますが起動パスと起動オプションを任意に設定できるタイプである必要あり
;
; Firefox系用 Open in Chrome™ Browser
;   https://addons.mozilla.org/ja/firefox/addon/open-in-chrome-browser
; Chrome系用 Open in Firefox™ Browser
;   https://chromewebstore.google.com/detail/open-in-firefox-browser/lmeddoobegbaiopohmpmmobpnpjifpii
; Firefox系用 External Application Launcher
;   https://addons.mozilla.org/ja/firefox/addon/external-application/
; Chrome系用 External Application Launcher
;   https://chromewebstore.google.com/detail/external-application-laun/bifmfjgpgndemajpeeoiopbeilbaifdo
;
; Usage:
;    OpenWithLite.exe "from" URL
;       "from"
;          起動元のブラウザ名文字列
;          (iniファイルに定義したものと一致する必要あり、選択肢に自分自身を入れないため)
;          (AddOn/拡張機能のオプションで起動オプションとして送信元文字列を定義出来る必要があります）
;       URL
;          ・Open In XXX Browserにて起動オプションに展開されるURL( &Expanded-URLs; または &Separated-URLs; )
;          ・External Application Launcherにて起動オプションに展開されるURL( [HREF] )
;          ※内部的にURLの前に " -URL " もしくは " -new-window " が付加されます
;
; OpenWithLite.ini に選択肢となるブラウザ一覧の定義が必要です
;


#NoTrayIcon
#SingleInstance Force

#Include AhkCommon.ahk

/* 非表示になっているアプリも対象とする（仮想デスクトップ上では通常表示のはずのウィンドウが非表示扱い？） */
#WinActivateForce
DetectHiddenWindows True

;//ToolTipはスクリーンを対象とする
CoordMode("ToolTip", "Screen")
/*
;//MouseGetPosはスクリーンを対象とする
CoordMode("Mouse", "Screen")
;//Menuの座標はスクリーンを対象とする
CoordMode("Menu", "Screen")

MouseGetPos( &posX, &posY, &posWin, &posCtrl )
*/

;//パラメータは２つ以上渡されるのが正常動作
if( A_Args.Length < 2 ){
	MsgBox( "ERROR: ArgsCount = " A_Args.Length "`r`nUsage:`r`n  OpenWithLite.exe [FROM] [URL]" )
	ExitApp
}

;//第一パラメータfromが "" で囲ってあるにも関わらず何故か内側のスペースで分離されて渡されるので再連結する
strFrom := ""
idx := 1
Loop (A_Args.Length - 1)
{
	strFrom := strFrom StrReplace(A_Args[idx],'"','') " "
	idx++
}
strFrom := Trim(strFrom)

;//最終パラメータがURL
strURL := A_Args[A_Args.Length]

;strToolTips := "[" strFrom "]" strURL
;ToolTip( strToolTips, 0, 0, 1 )

;iniファイルから定義件数を読み込む
IniFile := "OpenWithLite.ini"
IniSect := "APP"
count := IniRead(IniFile, IniSect, "MAX", 0)
if( count = 0 ){
	MsgBox( "ERROR: " IniFile "ファイルに定義がありません" )
	ExitApp()
}
strEditor      := IniRead(IniFile, IniSect, "EDIT", "C:\Windows\notepad.exe")
strBackColor   := IniRead(IniFile, IniSect, "COLOR", "FFFFFF")
iDispMine      := Number(IniRead(IniFile, IniSect, "DISPMINE", 0))
iEnableMine    := Number(IniRead(IniFile, IniSect, "ENABLEMINE", 0))
iDispNotExist  := Number(IniRead(IniFile, IniSect, "DISPNOTEXIST", 0))
iActivateTab   := Number(IniRead(IniFile, IniSect, "ACTIVATETAB", 1))
iActivateWin   := Number(IniRead(IniFile, IniSect, "ACTIVATEWIN", 0))
iOpenNewTab    := Number(IniRead(IniFile, IniSect, "OPENNEWTAB", 1))
MY_MARK        := " *"

;//ポップアップメニューを作成
try{
	MyMenu := Menu()
}catch{
	try{
		MyMenu := Menu()
	}catch{
		ExitApp()
	}
}

aryName := Array()
aryPath := Array()
aryIcon := Array()
aryOpts := Array()
idx := 1
pos := 1
Loop count
{
	strName := ""
	strPath := ""
	strIcon := ""
	strOpts := ""
	strTemp := ""
	iMine := 0
	iNotExist := 0

	;名前の読み込み(NAME1～) 両端の "" は除去
	strName := StrReplace(IniRead(IniFile, IniSect, "NAME" String(idx), ""),'"','')
	if( strName = strFrom ){
		if( iDispMine = 0  ){
			;MsgBox("strName[" strName "] is mine. Skip!")
			idx++
			Continue
		}else{
			iMine := 1
			strName := strName MY_MARK
		}
	}

	;フルパスの読み込み(PATH1～) 両端の "" はそのまま使う
	strPath := IniRead(IniFile, IniSect, "PATH" String(idx), "")
	if( ! FileExist(strPath) ){
		if( iDispNotExist = 0 ){
			;MsgBox("strPath[" strPath "] is not found. Skip!")
			idx++
			Continue
		}else{
			iNotExist := 1
		}
	}

	;アイコンの読み込み(ICON1～) 両端の "" はそのまま使い定義が無ければパス=EXEを指定
	strIcon := IniRead(IniFile, IniSect, "ICON" String(idx), strPath)

	;起動オプションの読み込み(OPTION1～) %AAA% の"%"は環境変数として扱うので必ず前後セットで使う
	strOpts := IniRead(IniFile, IniSect, "OPTION" String(idx), "")
	if( InStr(strOpts, "%") > 0 ){
		aryTemp := StrSplit(strOpts, "%")
		strOpts := ""
		pos := 1
		Loop(aryTemp.Length)
		{
			strTemp := aryTemp[pos]
			;// %AAA% で区切られている時は偶数インデックスが環境変数部
			if( Mod(pos,2) = 0 ){
				strOpts := strOpts EnvGet(strTemp)
			}else{
				strOpts := strOpts strTemp
			}
			pos++
		}
	}

	aryName.push( strName )
	aryPath.push( strPath )
	aryIcon.push( strIcon )
	aryOpts.push( strOpts )

	;//希にエラーとなるケースがあるがリトライすると成功する？
	try{
		MyMenu.Add(strName, MenuHandler)
	}catch{
		try{
			MyMenu.Add(strName, MenuHandler)
		}
	}
	try{
		MyMenu.SetIcon(strName, strIcon)
	}catch{
		try{
			MyMenu.SetIcon(strName, strIcon)
		}
	}
	if( (iMine && (!iEnableMine)) || iNotExist ){
		try{
			MyMenu.Disable(strName)
		}catch{
			try{
				MyMenu.Disable(strName)
			}
		}
	}

	idx++
}

;//セパレータを追加
try{
	MyMenu.Add()
}
;//iniファイル編集のメニューを追加
try{
	MyMenu.Add("OpenWithLite オプション", MenuHandlerOpt)
}
;//メニュー背景色
try{
	MyMenu.SetColor(strBackColor)
}
;//メニューを表示
try{
	MyMenu.Show()
}








;メニュー選択イベントハンドラ
MenuHandler(Item, *) {
	
	;//Shiftが押されているか、修飾キーなしで新しいウィンドウの設定（Ctrlが押されていたら常に新しいタブ）
	if( (! iOpenNewTab || GetKeyState("Shift")) && ! GetKeyState("Ctrl") ){
		;//新しいウィンドウで開く
		strPrefix := " -new-window "
		iNewWinMode := 1
	}else{
		;//新しいタブで開く
		strPrefix := " -URL "
		iNewWinMode := 0
	}
	idx := 1
	Loop aryName.Length
	{
		if( Item = aryName[idx] ){
			;//アクティブ化は新ウィンドウで開く場合は要らない(強制アクティブモードでは実施)
			if( (iActivateTab && ! iNewWinMode) || (iActivateWin && iNewWinMode) ){
				try{
					listWin := WinGetList("ahk_exe " aryPath[idx])
				}catch{
					listWin := Array()
				}
				for(hTgtW in listWin){
					try{
						style := WinGetStyle("ahk_id " hTgtW)
					}catch{
						style := 0
					}
					if( TestStyle( style, WS_BROWSER_ALLOW, WS_BROWSER_DENY ) ){
						try{
							WinActivate("ahk_id " hTgtW)
						}
						break
					}
				}
			}
			try{
				;//何故か新規に起動した場合にOpenWithLiteが終了すると開いたブラウザまで終了してしまう。解せぬ。
				;//Run( aryPath[idx] ' ' aryOpts[idx] strPrefix strURL )
				;//親プロセスから確実に切り離してcmd.exeからstartで起動する
				Run( A_ComSpec ' /c start "" "' aryPath[idx] '" ' aryOpts[idx] strPrefix strURL ,,"Hide" )
			}catch Error as err{
				MsgBox( "Caught Error: " type(err) " [" err.Message "]" )
			}
			break
		}
		idx++
	}
}

;オプション(ini)編集
MenuHandlerOpt(Item, *) {
	
	;MsgBox( A_ScriptDir "\" IniFile )
	Run( A_ComSpec ' /c start "" "' strEditor '" "' A_ScriptDir "\" IniFile '"',,"Hide" )
}



