﻿;//-----------------------------------------------------------------------------------------------------------------
;// MoveResizeWindow.ahk[UTF-8] (2026/02/10 14:00)
;// for AutoHotKey v2.0.21 or later
;//
;// http://coltpythonkingcobra.g1.xrea.com/pseudoTweetdeck/
;//                                             @PseudoTwDk
;//-----------------------------------------------------------------------------------------------------------------
;//
;
; 指定のウィンドウを移動やリサイズする(最小化・最大化状態ではリサイズが出来ないのでWinRestoreする)
;
;    MoveResizeWindow PosSizeAct Target (AllowStyle) (DenyStyle) (DispError) (Debug)
;       PosSizeAct
;          X, Y, Width, Height, Activate を両端""で囲って指定、移動だけしたい場合やリサイズだけしたい時は変更
;          しない値にnullを指定 例)移動だけする "0,0,null,null" / リサイズだけする "null,null,100,150"
;          Activate 1/ACT/Activate : ウィンドウをアクティブにする`n'
;                   2/F5/ActivateF5 : ウィンドウをアクティブにしてF5を送る`n'
;                   0/(none)/(Any) : アクティブにしない`n'
;       Target
;          ウィンドウ文字列/ahk_exe フルパス/ahk_class クラスID など両端""でAutoHotKey
;          独自のウィンドウ指定記述、現在アクティブなウィンドウを指定する場合は"A"
;          https://ahkscript.github.io/ja/docs/v2/misc/WinTitle.htm
;          対象ウィンドウのウィンドウスタイルは WS_VISIBLE ビットが有効で WS_DISABLED ビットが無効の
;          ものとしています。複数ウィンドウに該当する場合はエラー表示し処理しません。
;          マッチを正規表現で記述したい時は先頭に"REGEX:"を書きます
;          AutoHotKeyV2の正規表現文法は下記参照
;          https://ahkscript.github.io/ja/docs/v2/misc/RegEx-QuickRef.htm
;          ex) "ahk_exe C:\Program Files\Mozilla Firefox\firefox.exe"
;          ex) "ahk_exe C:\Program Files\Vivaldi\Application\vivaldi.exe ahk_class Chrome_WidgetWin_1"
;       AllowStyle
;          処理対象であるウィンドウスタイルのビット積(andをとってマスク自身になれば対象)の16進表記
;          省略された場合やdef/defaultと書かれた時は 0x10000000(WS_VISIBLE) が指定されたものとします
;          全てを対象外にしてしまう 0x00000000 は指定できません
;       DenyStyle
;          処理対象から除外するウィンドウスタイルのビット積(andをとって0になれば対象)の16進表記
;          省略された場合やdef/defaultと書かれた時は 0x08000000(WS_DISABLED) が指定されたものとします
;          全てを対象外にしてしまう 0xFFFFFFFF は指定できません
;       DispError
;          1/on/disp : 対象ウィンドウが見つからない時や複数ヒットした際のエラーダイアログを出す
;          [any] : 上記以外が指定されるか無指定ならエラー時にダイアログを出さない
;       DebugMode
;          1/on/debug : デバッグモードON
;          [any] : 上記以外が指定されるか無指定ならデバッグモードOFF
;

/* 同時に複数実行を許可する */
#SingleInstance Off

#WinActivateForce
/* 非表示のウィンドウも捜索対象としておかないと仮想デスクトップで動作しない */
DetectHiddenWindows True

#Include AhkCommon.ahk


/* コマンドオプション数チェック */
if( A_Args.Length < 2 ){
	DispUsage()
}

/* モードとウィンドウ指定 */
strPosSize := A_Args[1]
strTarget := A_Args[2]
arg_regx := 2
if( StrUpper(SubStr(strTarget,1,6)) = "REGEX:" ){
	strTarget := TargetToREGEX(strTarget)
	arg_regx := "RegEx"
	strTarget := SubStr(strTarget,7)
}
iAct := 0
iDisp := 0
iPopup := 0
iDebug := 0
iPost := 0
UniqueID := 0
iAllowStyle := 0
iDenyStyle := 0xFFFFFFFF

;両端のダブルクォートを削除し、カンマ区切りを配列に分割
strPosSize := StrReplace(strPosSize, '"', "")
strPosSize := StrReplace(strPosSize, ' ', "")
aryTemp := StrSplit(strPosSize, ",")
;座標とサイズを数値化
try{
	if( StrUpper(aryTemp[1]) = "NUL" || StrUpper(aryTemp[1]) = "NULL" ){
		aryTemp[1] := "NULL"
	}else{
		aryTemp[1] := Number(aryTemp[1])
	}
	if( StrUpper(aryTemp[2]) = "NUL" || StrUpper(aryTemp[2]) = "NULL" ){
		aryTemp[2] := "NULL"
	}else{
		aryTemp[2] := Number(aryTemp[2])
	}
	if( StrUpper(aryTemp[3]) = "NUL" || StrUpper(aryTemp[3]) = "NULL" ){
		aryTemp[3] := "NULL"
	}else{
		aryTemp[3] := Number(aryTemp[3])
	}
	if( StrUpper(aryTemp[4]) = "NUL" || StrUpper(aryTemp[4]) = "NULL" ){
		aryTemp[4] := "NULL"
	}else{
		aryTemp[4] := Number(aryTemp[4])
	}
	/* ACTIVATE */
	if( aryTemp.Length < 5 ){
		aryTemp.Length := 5
		aryTemp[5] := 0
	}
	if( StrUpper(aryTemp[5]) = "1" || StrUpper(aryTemp[5]) = "ACT" || StrUpper(aryTemp[5]) = "ACTIVATE" ){
		aryTemp[5] := 1
		iAct := 1
	}else if( StrUpper(aryTemp[5]) = "2" || StrUpper(aryTemp[5]) = "F5" || StrUpper(aryTemp[5]) = "ACTIVATEF5" ){
		aryTemp[5] := 2
		iAct := 2
	}else{
		aryTemp[5] := 0
		iAct := 0
	}
}catch{
	/* 座標に分解できない書式の時 */
	DispUsage()
}


/* 必須ウィンドウスタイルの扱い */
if( A_Args.Length >= 3 ){
	iAllowStyle := A_Args[3]
}
if( iAllowStyle = 0 || StrUpper(iAllowStyle) = "DEF" || StrUpper(iAllowStyle) = "DEFAULT" ){
	iAllowStyle := WS_VISIBLE
}else{
	iAllowStyle := StyleNumber(iAllowStyle,WS_VISIBLE)
}

/* 除外ウィンドウスタイルの扱い */
if( A_Args.Length >= 4 ){
	iDenyStyle := A_Args[4]
}
if( iDenyStyle = 0xFFFFFFFF || StrUpper(iDenyStyle) = "DEF" || StrUpper(iDenyStyle) = "DEFAULT" ){
	iDenyStyle := WS_DISABLED
}else{
	iDenyStyle := StyleNumber(iDenyStyle,WS_DISABLED)
}


/* エラーダイアログの扱い */
if( A_Args.Length >= 5 ){
	iDisp := A_Args[5]
}
if( iDisp = 1 || StrUpper(iDisp) = "ON" || StrUpper(iDisp) = "DISP" ){
	iDisp := 1
}else{
	iDisp := 0
}

/* デバッグモードの指定 */
if( A_Args.Length >= 6 ){
	iDebug := A_Args[6]
}
if( iDebug = 1 || StrUpper(iDebug) = "ON" || StrUpper(iDebug) = "DEBUG" ){
	iDebug := 1
	LogInit("MoveResizeWindow","AutoHotKeyV2_debug_log.txt")
}else{
	iDebug := 0
}

if( iDebug ){
	LogOutput( "PATH=" strTarget " REGX=" arg_regx " Allow=" StrHex8(iAllowStyle) " Deny=" StrHex8(iDenyStyle) )
	LogOutput("SizePos: " String(aryTemp[1]) ","
						. String(aryTemp[2]) ","
						. String(aryTemp[3]) ","
						. String(aryTemp[4]) ","
						. String(aryTemp[5]) )
}


/* タイトルマッチモードの設定(2=部分一致, "RegEx"=正規表現) */
SetTitleMatchMode(arg_regx)

/* フルパスに合致するウィンドウを列挙(非表示ウィンドウも対象としているため沢山ヒットする) */
listWin := WinGetList(strTarget)
idxWin := 0
findCount := 0

/* ウィンドウスタイルでマスク */
for(hWin in listWin){
	idxWin := idxWin + 1
	try{
		style := WinGetStyle("ahk_id " hWin)
		if( iDebug ){
			LogOutput("Style=" StrHex8(style) " Allow=" StrHex8(iAllowStyle) " Deny=" StrHex8(iDenyStyle) " Class[" idxWin "]=" WinGetClass("ahk_id " hWin) )
		}
		if( TestStyle( style, iAllowStyle, iDenyStyle, hWin ) ){
			findCount++
			UniqueID := hWin
			if( iDebug ){
				LogOutput("* Class[" idxWin "]=" WinGetClass("ahk_id " hWin) " / style=0x" StrUpper(Format("{1:X}",style)) )
			}
		}
	}
}

if( UniqueID = 0 ){
	if( iDisp ){
		MsgBox(strTarget " not found.")
	}
	if( iDebug ){
		LogOutput(strTarget " not found.")
	}
	ExitApp(1)
}

if( findCount != 1 ){
	if( iDisp ){
		MsgBox(strTarget " has multiple windows.")
	}
	if( iDebug ){
		LogOutput(strTarget " has multiple windows.")
	}
	ExitApp(1)
}

/* WinActivateを実施する場合 */
if( iAct = 1 ){
	try{
		WinActivate("ahk_id " UniqueID)
		if( iDebug ){
			LogOutput("WinActivate : " UniqueID)
		}
	}catch TargetError as err{
		if( iDisp ){
			MsgBox(strTarget " can not activate")
		}
		if( iDebug ){
			LogOutput(strTarget " can not activate")
		}
		ExitApp(1)
	}
}
if( iAct = 2 ){
	try{
		WinActivate("ahk_id " UniqueID)
		Send("{F5}")
		if( iDebug ){
			LogOutput("WinActivate + Send F5 : " UniqueID)
		}
	}catch TargetError as err{
		if( iDisp ){
			MsgBox(strTarget " can not activate")
		}
		if( iDebug ){
			LogOutput(strTarget " can not activate")
		}
		ExitApp(1)
	}
}

style := WinGetStyle("ahk_id " UniqueID)
;MsgBox("Class=" WinGetClass("ahk_id " UniqueID) " / style=0x" StrUpper(Format("{1:X}",style)) )

try{
	if( WinGetMinMax("ahk_id " UniqueID) != 0 ){
		WinRestore("ahk_id " UniqueID)
	}
}

try{
	if( aryTemp[1] != "NULL" && aryTemp[2] != "NULL" && aryTemp[3] != "NULL" && aryTemp[4] != "NULL" ){
		/* 移動とリサイズ */
		WinMove( aryTemp[1], aryTemp[2], aryTemp[3], aryTemp[4], "ahk_id " UniqueID )
		if( iDebug ){
			LogOutput("WinMove : (" aryTemp[1] "," aryTemp[2] "," aryTemp[3] "," aryTemp[4] ")" )
		}
	}else if( (aryTemp[1] = "NULL" || aryTemp[2] = "NULL") && aryTemp[3] != "NULL" && aryTemp[4] != "NULL" ){
		/* リサイズ */
		WinMove( ,, aryTemp[3], aryTemp[4], "ahk_id " UniqueID )
		if( iDebug ){
			LogOutput("WinMove : ( , ," aryTemp[3] "," aryTemp[4] ")" )
		}
	}else if( aryTemp[1] != "NULL" && aryTemp[2] != "NULL" && (aryTemp[3] = "NULL" || aryTemp[4] = "NULL") ){ 
		/* 移動 */
		WinMove( aryTemp[1], aryTemp[2],,, "ahk_id " UniqueID )
		if( iDebug ){
			LogOutput("WinMove : (" aryTemp[1] "," aryTemp[2] ", , )" )
		}
	}
}catch{
	try{
		Sleep(1000)
		if( aryTemp[1] != "NULL" && aryTemp[2] != "NULL" && aryTemp[3] != "NULL" && aryTemp[4] != "NULL" ){
			/* 移動とリサイズ */
			WinMove( aryTemp[1], aryTemp[2], aryTemp[3], aryTemp[4], "ahk_id " UniqueID )
			if( iDebug ){
				LogOutput("WinMove [RETRY]: (" aryTemp[1] "," aryTemp[2] "," aryTemp[3] "," aryTemp[4] ")" )
			}
		}else if( (aryTemp[1] = "NULL" || aryTemp[2] = "NULL") && aryTemp[3] != "NULL" && aryTemp[4] != "NULL" ){
			/* リサイズ */
			WinMove( ,, aryTemp[3], aryTemp[4], "ahk_id " UniqueID )
			if( iDebug ){
				LogOutput("WinMove [RETRY]: ( , ," aryTemp[3] "," aryTemp[4] ")" )
			}
		}else if( aryTemp[1] != "NULL" && aryTemp[2] != "NULL" && (aryTemp[3] = "NULL" || aryTemp[4] = "NULL") ){ 
			/* 移動 */
			WinMove( aryTemp[1], aryTemp[2],,, "ahk_id " UniqueID )
			if( iDebug ){
				LogOutput("WinMove [RETRY]: (" aryTemp[1] "," aryTemp[2] ", , )" )
			}
		}
	}
}

ExitApp(0)

DispUsage(){
	msg := 'Usage:`n'
	msg := msg 'MoveResizeWindow.exe PosSizeAct Target (...options)`n`n'
	msg := msg '[PosSizeAct]`n'
	msg := msg '    "X, Y, Width, Height, Activate"`n'
	msg := msg '      5thParam 1/ACT/Activate=WinActivate`n'
	msg := msg '      5thParam 2/F5/ActivateF5=WinActivate and SendF5`n'
	msg := msg '      5thParam 0/(none)/(Any)=Do not Activate`n'
	msg := msg '    ex) move and resize "100, 50, 320, 480"`n'
	msg := msg '    ex) move only "150, 200, null, null, Activate"`n'
	msg := msg '    ex) resize only "null, null, 250, 300"`n'
	msg := msg '    ex) ActivateF5 only "null, null, null, null, F5"`n'
	msg := msg '[Param]`n'
	msg := msg '   "window-title / REGEX:match-title-str`n'
	msg := msg '    ahk_exe full-path`n'
	msg := msg '    ahk_class class-name..."`n'
	msg := msg '[AllowStyle]`n'
	msg := msg '    enabled WindowStyle Bits`n'
	msg := msg '    def/default = 0x10000000(WS_VISIBLE)`n'
	msg := msg '    ex) 0x16C70000`n'
	msg := msg '[DenyStyle]`n'
	msg := msg '    disabled WindowStyleBits`n'
	msg := msg '    def/default = 0x08000000(WS_DISABLED)`n'
	msg := msg '    ex) 0xE8000000`n'
	msg := msg '[DispError]`n'
	msg := msg '    1/on/disp = display ErrorDialog`n'
	msg := msg '[DebugMode]`n'
	msg := msg '    1/on/debug = Debug mode`n'
	MsgBox(msg)
	ExitApp(1)
}


