﻿;//-----------------------------------------------------------------------------------------------------------------
;// MinimizeAllWindow.ahk[UTF-8] (2026/02/10 14:00)
;// for AutoHotKey v2.0.21 or later
;//
;// http://coltpythonkingcobra.g1.xrea.com/pseudoTweetdeck/
;//                                             @PseudoTwDk
;//-----------------------------------------------------------------------------------------------------------------
;//
;
; 全ウィンドウの最小化と復元切替を行う
;    MinimizeAllWindow.exe Mode
;       Mode
;          1/on/hide         : 全ウィンドウを最小化する
;          2/off/res/restore : 元に戻す
;       DebugMode
;          1/on/debug        : デバッグモードON
;          [any]             : 上記以外が指定されるか無指定ならデバッグモードOFF
;

/* 同時に複数実行を許可する */
#SingleInstance Off

#Include AhkCommon.ahk

/* コマンドオプション数チェック */
if( A_Args.Length < 1 ){
	DispUsage()
}

/* モード */
iMode := A_Args[1]

/* モードの扱い */
if( iMode = 1 || StrUpper(iMode) = "ON" || StrUpper(iMode) = "HIDE" ){
	iMode := 1
}else if( iMode = 0 || iMode = 2 || StrUpper(iMode) = "OFF" || StrUpper(iMode) = "RES" || StrUpper(iMode) = "RESTORE" ){
	iMode := 2
}else{
	DispUsage()
}

/* デバッグモードの指定 */
iDebug := 0
if( A_Args.Length >= 2 ){
	iDebug := A_Args[2]
}
if( iDebug = 1 || StrUpper(iDebug) = "ON" || StrUpper(iDebug) = "DEBUG" ){
	iDebug := 1
	LogInit("MinimizeAllWindow","AutoHotKeyV2_debug_log.txt")
}else{
	iDebug := 0
}


try{
	if( iMode = 1 ){
		WinMinimizeAll()
		if( iDebug ){
			LogOutput( "WinMinimizeAll : MODE=" iMode )
		}
	}else{
		WinMinimizeAllUndo()
		if( iDebug ){
			LogOutput( "WinMinimizeAllUndo : MODE=" iMode )
		}
	}
	ExitApp(0)
}catch{
	if( iDebug ){
		LogOutput( "WinMinimize ERROR" )
	}
	ExitApp(1)
}


DispUsage(){
	msg := 'Usage:`n'
	msg := msg 'MinimizeAllWindow.exe Mode`n`n'
	msg := msg '[Mode]`n'
	msg := msg '    1/on/hide = Minimize All Window`n'
	msg := msg '    0/off/res/restore = Restore Window`n'
	msg := msg '[DebugMode]`n'
	msg := msg '    1/on/debug = Debug mode`n'
	MsgBox(msg)
	ExitApp(1)
}


