﻿;//-----------------------------------------------------------------------------------------------------------------
;// ListWindow.ahk[UTF-8] (2026/02/10 14:00)
;// for AutoHotKey v2.0.21 or later
;//
;// http://coltpythonkingcobra.g1.xrea.com/pseudoTweetdeck/
;//                                             @PseudoTwDk
;//-----------------------------------------------------------------------------------------------------------------
;//
;
; 各種ブラウザなどのウィンドウ一覧を取得してテキストに吐き出す
; 全ウィンドウと、空行を挟んで通常メインウィンドウにされていると思われるウィンドウ
; (WS_VISIBLEがONでWS_DISABLEDがOFFであるウィンドウ)を列挙
;

#Include AhkCommon.ahk

CoordMode("Mouse", "Screen")
CoordMode("ToolTip", "Screen")

#WinActivateForce
/* 非表示のウィンドウも捜索対象としておく */
DetectHiddenWindows True

WM_SYSCOMMAND := 0x112
SC_MINIMIZE := 0xF020
SC_MAXIMIZE := 0xF030
SC_RESTORE := 0xF120

IniFile    := "ListWindow.ini"
IniSect    := "APP"
OutputFile := "ListWindow.txt"

;iniファイルから件数を読み込む
count := IniRead(IniFile, IniSect, "MAX", 0)
if( count = 0 ){
	MsgBox("iniファイルに定義がありません")
	ExitApp()
}
countM := count

showToolTip := Number(IniRead(IniFile, IniSect, "ToolTip", "0"))

if( showToolTip ){
	try{
		hwndToolTips := ToolTip( "ウィンドウ情報を収集しています", A_ScreenWidth / 2, A_ScreenHeight / 2, 1 )
		WinGetPos( &OutX, &OutY, &OutW, &OutH, "ahk_id " hwndToolTips )
		WinMove( (A_ScreenWidth - OutW) / 2, (A_ScreenHeight - OutH) / 2, OutW, OutH, "ahk_id " hwndToolTips )
	}
}

/* クラス名文字列の長さ、出力可否 */
ClassLen := Number(IniRead(IniFile, IniSect, "ClassLen", "50"))
ClassOutput := Number(IniRead(IniFile, IniSect, "ClassOutput", "0"))

/* タイトル文字列の長さ、出力可否 */
TitleLen := Number(IniRead(IniFile, IniSect, "TitleLen", "50"))
TitleOutput := Number(IniRead(IniFile, IniSect, "TitleOutput", "0"))

/* コマンドライン文字列の長さ、出力可否 */
ComLen := Number(IniRead(IniFile, IniSect, "ComLen", "512"))
ComOutput := Number(IniRead(IniFile, IniSect, "ComOutput", "0"))


listText := Array()
listTextAll := Array()
idxWin := 0

idx := 1
while( count > 0 ){
	;フルパスの読み込み(PATH1～)
	strTemp := IniRead(IniFile, IniSect, "PATH" String(idx), "")

	if( showToolTip ){
		try{
			hwndToolTips := ToolTip( "ウィンドウを列挙しています(" idx "/" countM ")`r`n" strTemp, A_ScreenWidth / 2, A_ScreenHeight / 2, 1 )
			WinGetPos( &OutX, &OutY, &OutW, &OutH, "ahk_id " hwndToolTips )
			WinMove( (A_ScreenWidth - OutW) / 2, (A_ScreenHeight - OutH) / 2, OutW, OutH, "ahk_id " hwndToolTips )
		}
	}

	getWindowList(strTemp)
	count--
	idx++
}

msgText := ""
for(tmpText in listTextAll){
	msgText := msgText tmpText
}
msgText := msgText "`r`n"
for(tmpText in listText){
	msgText := msgText tmpText
}


/* 新規ファイルに出力するモードの場合は削除 */
if( Number(IniRead(IniFile, IniSect, "NewFile", "0")) ){
	try{
		FileDelete(OutputFile)
	}
}

if( Number(IniRead(IniFile, IniSect, "SJIS", "1")) ){
	opt := "cp932"
}else{
	opt := "`n UTF-8"
}

;A_Clipboard := msgText
FileAppend( msgText, OutputFile, opt)

/* 出力ファイルをすぐに開く */
if( Number(IniRead(IniFile, IniSect, "OpenFile", "0")) ){
	try{
		Run(OutputFile)
	}
}


ExitApp()



getWindowList(param){
	
	global idxWin, listText, listTextAll, SPC
	
	listWin := WinGetList("ahk_exe " param)
	for(hWin in listWin){
		idxWin++
		style := StrHex8(0)
		styleEx := StrHex8(0)
		class := ""
		title := ""
		path := ""
		comLine := ""
		strIdx := StrNum4(idxWin)

		try{
			style := WinGetStyle("ahk_id " hWin)
			styleEx := WinGetExStyle("ahk_id " hWin)
			class := WinGetClass("ahk_id " hWin)
			title := WinGetTitle("ahk_id " hWin)
			path := WinGetProcessPath("ahk_id " hWin)
			strStyle := StrHex8(style)
			strStyleEx := StrHex8(styleEx)

			if( ComOutput ){
				try{
					;//起動オプションを取得
					pid := WinGetPID("ahk_id " hWin)
					;//WMIサービスオブジェクトを取得
					wmi := ComObjGet("winmgmts:")
					;//クエリーを実行し、一致するプロセスを取得
					queryEnum := wmi.ExecQuery(""
								. "Select * from Win32_Process where ProcessId=" . pid)
								._NewEnum()
					;//最初のマッチング処理を取得
					if queryEnum(&proc){
						comLine := proc.CommandLine
					}
					wmi := ""
					queryEnum := ""
				}
			}

		} catch Error as err {
			path := ""
		}

		try{
			WinGetPos( &OutX, &OutY, &OutW, &OutH, "ahk_id " hWin )
		} catch Error as err {
			hWin := 0
			OutX := 0
			OutY := 0
			OutW := 0
			OutH := 0
		}
		OutX := StrSpaceRight(OutX,6)
		OutY := StrSpaceRight(OutY,6)
		OutW := StrSpaceRight(OutW,6)
		OutH := StrSpaceRight(OutH,6)

		;//出力テキスト整形
		text := "[" strIdx "] Style=" strStyle ",Ex=" strStyleEx ",PosSize(" OutX "," OutY ") [" OutW "x" OutH "]"

		;//クラス名を出力する場合
		if( ClassOutput ){
			class := ",class=" StrSpaceLeftA(class, ClassLen)
		}else{
			class := ""
		}

		;//ウィンドウタイトルを出力する場合
		if( TitleOutput ){
			title := ",title=" StrSpaceLeftA(title, TitleLen)
		}else{
			title := ""
		}

		;//コマンドラインオプションを出力する場合
		if( ComOutput ){
			path := StrSpaceLeftA(path " ( " comLine " )", ComLen)
		}

		if( path != "" ){
			text := text class title "," path "`r`n"
			if( (style & WS_VISIBLE) && !(style & WS_DISABLED ) ){
				;//メインウィンドウと思われるもの
				listText.push(text)
			}else{
				;//その他のウィンドウ
				listTextAll.push(text)
			}
		}
	}
}



;
; クリップボードにコピー
;   A_Clipboard := ""
;
; クリップボードをコンソールに出力
;   powershell -command "get-clipboard"
;

