﻿;//-----------------------------------------------------------------------------------------------------------------
;// DisableMaxButton.ahk[UTF-8] (2026/02/19 17:30)
;// for AutoHotKey v2.0.21 or later
;//
;// http://coltpythonkingcobra.g1.xrea.com/pseudoTweetdeck/
;//                                             @PseudoTwDk
;//-----------------------------------------------------------------------------------------------------------------
;//
;//
;// 最大化して使うことのないアプリの最大化ボタンを無効にする
;// ※Win32APIに乗っ取らずに独自のシステムメニューアイコンを実装しているアプリケーション
;//   では効きません。Firefox, Thunderbird, Chrome などが対象外となります。
;//
;// 使い方
;//  各種パラメータはiniファイルに記述します
;//

;//多重起動時ダイアログボックスをスキップして既存インスタンスを終了させ新しいインスタンスを起動
#SingleInstance Force

;@Ahk2Exe-AddResource DisableMaxButton.ico, 1
;@Ahk2Exe-AddResource DisableMaxButton2.ico, 2
TraySetIcon(,,true)
try{
	TraySetIcon(A_ScriptFullPath,1)
}catch{
	TraySetIcon("DisableMaxButton.ico")
}
IniFile := "DisableMaxButton.ini"
IniSect := "APP"

#Include AhkCommon.ahk


;//MouseGetPosはスクリーンを対象とする
CoordMode("Mouse", "Screen")


;//タスクトレイアイコンにメニュー項目追加
A_TrayMenu.Insert("1&", "Reload DisableMaxButton", handleMenuItemReload)
A_TrayMenu.Insert("2&", "Edit INI file", handleMenuItemEdit)
A_TrayMenu.Insert("3&", "Pause and Suspend", handleMenuItemStop)
A_TrayMenu.Delete("5&")
A_TrayMenu.Delete("4&")

MY_APP_ID := APP_DISABLEMAXBUTTON
DEF_MENU := "Pause and Suspend"
A_TrayMenu.Default := DEF_MENU
A_TrayMenu.ClickCount := 1


;//変数初期化
Path := Array()
Regx := Array()

;//iniファイルから件数を読み込む
count := IniRead(IniFile, IniSect, "MAX", 0)
if( count = 0 ){
	MsgBox("iniファイルに定義がありません")
	ExitApp()
}
NextWait   := Number(IniRead(IniFile, IniSect, "NextWait", "10"))
LoopWait   := Number(IniRead(IniFile, IniSect, "LoopWait", "100"))
ExecWait   := Number(IniRead(IniFile, IniSect, "ExecWait", "250"))
iSyncPause := Number(IniRead(IniFile, IniSect, "SyncPause", "0"))
iDebug     := Number(IniRead(IniFile, IniSect, "DEBUG_LOG", "0"))
iDelete    := Number(IniRead(IniFile, IniSect, "DELETE_LOG", "1"))
iLogLine   := Number(IniRead(IniFile, IniSect, "DEBUG_LOG_LINE", "0"))
iLogSJIS   := Number(IniRead(IniFile, IniSect, "DEBUG_LOG_SJIS", "1"))
LOG_PATH   := "DisableMaxButtonLog.txt"

if( iDelete || iLogLine ){
	try{
		FileDelete(LOG_PATH)
	}
}
if( iDebug ){
	A_TrayMenu.Insert("3&", "Open LOG file", handleMenuItemLog)
	LogInit( "DisableMaxButton", LOG_PATH,, iLogSJIS,,, iLogLine)
	LogOutput("DisableMaxButton Start",,1)
	LogOutput("■Load Setting.",,1)
}


idx := 1
while( count > 0 ){
	;//フルパスの読み込み(PATH1～)
	strTemp := IniRead(IniFile, IniSect, "PATH" String(idx), "")
	arg_regx := 2
	if( StrUpper(SubStr(strTemp,1,6)) = "REGEX:" ){
		strTemp := TargetToREGEX(strTemp)
		arg_regx := "RegEx"
		strTemp := SubStr(strTemp,7)
	}

	if( iDebug ){
		;//LogOutput("Target [" idx "] Path=" strTemp " RegEx=" arg_regx,,1)
		LogOutput("Target [" idx "] Path=" REGEXToTarget(strTemp) " RegEx=" arg_regx,,1)
	}
	Path.Push( strTemp )
	Regx.Push( arg_regx )

	count--
	idx++
}


;//プロセス間通信
if( iSyncPause ){
	OnMessage(MSG_SYNC_PAUSE, DoSyncPauseAction)
	if( iDebug ){
		LogOutput("OnMessage[MSG_SYNC_PAUSE] Listening Start.")
	}
}

DoSyncPauseAction(wParam, lParam, msg, hwnd){
	if( iSyncPause ){
		if( iDebug ){
			LogOutput("OnMessage[MSG_SYNC_PAUSE] val:" StrHex4(lParam) " from:" StrHex4(wParam) "(" gObj_SyncPauseAppList[wParam] ")")
		}
		return SyncPause( MY_APP_ID, lParam, 0, DEF_MENU )
	}
}


idx := 1
WS_MAXIMIZEBOX  := 0x10000    ;最大化ボタンが有効である(取得用)
DS_MAXIMIZEBOX  := "-0x10000" ;最大化ボタンを無効にする(設定変更用)

;//順次対象ウィンドウかどうかを調べてスタイル変更
Loop
{
	while( Path.Length >= idx ){

		;//タイトルマッチモードの設定(2=部分一致, "RegEx"=正規表現)
		SetTitleMatchMode( Regx[idx] )

		Style := 0
		fullPath := ""
		className := ""
		hWnd := WinActive( Path[idx] )
		if( hWnd != 0 ){
			;MsgBox( "Path=" Path[idx] )
			;//マウスのドラッグ操作中やスクロール中は動作させない
			IsDown1 := GetKeyState("LButton") || GetKeyState("RButton") || GetKeyState("MButton")
			IsDown2 := GetKeyState("WheelUp") || GetKeyState("WheelDown") || GetKeyState("WheelLeft") || GetKeyState("WheelRight")
			if( IsDown1 = 0 && IsDown2 = 0 ){
				try{
					Style := WinGetStyle( "ahk_id " hWnd )
					fullPath := WinGetProcessPath( "ahk_id " hWnd )
					className := WinGetClass( "ahk_id " hWnd )
				} catch Error as err {
					hWnd := 0
					Style := 0
				}
				if( (Style & WS_MAXIMIZEBOX) && hWnd != 0 ){
					;//MsgBox( Format( "0x{1:x}", Style ) )
					;//起動直後などウィンドウ構築中にウィンドウスタイルを変更するとハングアップすることがあるので少し待つ
					if( iDebug ){
						LogOutput("WinGetStyle : idx=" StrNum2(idx) " Style=" StrHex8(Style) " FullPath=" fullPath " Class=" className )
					}
					Sleep(ExecWait)
					try{
						WinSetStyle( DS_MAXIMIZEBOX, "ahk_id " hWnd )
						newStyle := WinGetStyle( "ahk_id " hWnd )
						if( iDebug ){
							LogOutput("WinSetStyle : idx=" StrNum2(idx) " Style=" StrHex8(newStyle) " "
									. "Path=" REGEXToTarget(Path[idx]) " RegEx=" Regx[idx] )
						}
					} catch Error as err {
						;//
					}
				}
			}
		}
		idx++
		Sleep(NextWait)
	}
	idx := 1
	Sleep(LoopWait)
}

;//メニューからの呼び出し
handleMenuItemReload(ItemName, ItemPos, MyMenu){
	Reload
}

handleMenuItemEdit(ItemName, ItemPos, MyMenu){
	try {
		Run(IniFile)
	}
}

handleMenuItemStop(ItemName, ItemPos, MyMenu){
	SyncPause( MY_APP_ID, -1, iSyncPause, DEF_MENU )
}

handleMenuItemLog(ItemName, ItemPos, MyMenu){
	try {
		Run(LOG_PATH)
	}
}



