﻿;//-----------------------------------------------------------------------------------------------------------------
;// ActivePseudo.ahk[UTF-8] (2026/02/23 19:20)
;// for AutoHotKey v2.0.21 or later
;//
;// http://coltpythonkingcobra.g1.xrea.com/pseudoTweetdeck/
;//                                             @PseudoTwDk
;//-----------------------------------------------------------------------------------------------------------------
;//
;//
;// 仮想デスクトップ上に起動されたVivaldiを一定周期ごとにアクティブに切り替えて
;// 低プライオリティ動作でタイマイベント類が滞留することで起きるタブのクラッシュ
;// を抑止します。
;//
;// 使い方
;//  各種パラメータはiniファイルに記述します
;//
;// マウスが動かない時間が一定時間以上になったら１つめのフルパスをインターバル
;// 秒後にアクティブ化し、それを繰り返し回数ぶん繰り返したら２つめのフルパスに
;// 移り最後のパスまで処理されると１つめのパスに戻り全体の処理を繰り返します。
;// 途中でマウスが動くと中断し、また一定時間操作されないと動作を再開します。
;//

;//多重起動時ダイアログボックスをスキップして既存インスタンスを終了させ新しいインスタンスを起動
#SingleInstance Force

;@Ahk2Exe-AddResource ActivePseudo.ico, 1
;@Ahk2Exe-AddResource ActivePseudo2.ico, 2
TraySetIcon(,,true)
try{
	TraySetIcon(A_ScriptFullPath,1)
}catch{
	TraySetIcon("ActivePseudo.ico")
}
IniFile       := "ActivePseudo.ini"
IniSect       := "APP"

#Include AhkCommon.ahk

;//ToolTipはスクリーンを対象とする
CoordMode("ToolTip", "Screen")

;//MouseGetPosはスクリーンを対象とする
CoordMode("Mouse", "Screen")

;//非表示になっているアプリも対象とする（仮想デスクトップ上では通常表示のはずのウィンドウが非表示扱い？）
#WinActivateForce
DetectHiddenWindows True


/* タスクトレイアイコンにメニュー項目追加 */
A_TrayMenu.Insert("1&", "ExecForce after 5sec", handleMenuItemStart)
A_TrayMenu.Insert("2&", "Reload ActivePseudo", handleMenuItemReload)
A_TrayMenu.Insert("3&", "Edit INI file", handleMenuItemEdit)
A_TrayMenu.Insert("4&", "Pause and Suspend", handleMenuItemStop)
A_TrayMenu.Delete("6&")
A_TrayMenu.Delete("5&")

MY_APP_ID := APP_ACTIVEPSEUDO
DEF_MENU := "ExecForce after 5sec"
A_TrayMenu.Default := DEF_MENU
A_TrayMenu.ClickCount := 1


/* 変数初期化 */
POS_LIMIT     := Number(IniRead(IniFile, IniSect, "PosLimit", "5"))
lastTime      := A_Now
lastX         := -1
lastY         := -1
idx           := 1
page          := 1
modeActive    := 1 ;// 1=マウスが動いてる, 0=一定時間以上止まっている
;//操作対象ウィンドウ関連配列
pathArray     := Array()
fileArray     := Array()
Regx          := Array()
tabsArray     := Array()
tabsArray.Default := "0" ;//配列が格納される配列なので初期値を設定しておく
repsArray     := Array()
keysArray     := Array()
allowArray    := Array()
denyArray     := Array()
diffArray     := Array()
lastF5Array   := Array()
sendArray     := Array()
;//無視対象ウィンドウ関連配列
ignoreWindow  := Array()
ignoreRegx    := Array()
ignoreAllow   := Array()
ignoreDeny    := Array()
;//非通知設定関連配列
silentWindow  := Array()
silentRegx    := Array()
silentAllow   := Array()
silentDeny    := Array()
;//常時表示ウィンドウ関連配列
defaultWindow := Array()
defaultRegx   := Array()
defaultAllow  := Array()
defaultDeny   := Array()

;//ini定義読込
iDebugTooltips:= Number(IniRead(IniFile, IniSect, "DEBUG_TOOLTIPS", "0"))
iDebug        := Number(IniRead(IniFile, IniSect, "DEBUG_LOG", "0"))
iDelete       := Number(IniRead(IniFile, IniSect, "DELETE_LOG", "1"))
iLogLine      := Number(IniRead(IniFile, IniSect, "DEBUG_LOG_LINE", "0"))
iLogSJIS      := Number(IniRead(IniFile, IniSect, "DEBUG_LOG_SJIS", "1"))
LOG_PATH      := "ActivePseudoLog.txt"

noDialog      := Number(IniRead(IniFile, IniSect, "NoDialog", "0"))
noTgtDialog   := Number(IniRead(IniFile, IniSect, "NoTgtDialog", "0"))
maxPath       := Number(IniRead(IniFile, IniSect, "MAX", "1"))
intervalSec   := Number(IniRead(IniFile, IniSect, "Interval", "10"))
pastMin       := Number(IniRead(IniFile, IniSect, "PastMin", "10"))
msgTime       := Number(IniRead(IniFile, IniSect, "MsgTime", "1"))
tipsOffset    := Number(IniRead(IniFile, IniSect, "TipsOffset", "140"))
displayMulti  := Number(IniRead(IniFile, IniSect, "DisplayMulti", "0"))
tipsDisplayS  := Number(IniRead(IniFile, IniSect, "TipsDisplayS", "-1600"))
tipsDisplayL  := Number(IniRead(IniFile, IniSect, "TipsDisplayL", "1920"))
displayLimitS := Number(IniRead(IniFile, IniSect, "DisplayLimitS", "0"))
displayLimitL := Number(IniRead(IniFile, IniSect, "DisplayLimitL", "1920"))
mouseLimitY   := Number(IniRead(IniFile, IniSect, "MouseLimitY", "9999"))
audioPlaying  := Number(IniRead(IniFile, IniSect, "AudioPlaying", "0"))
audioThreshold:= Number(IniRead(IniFile, IniSect, "AudioThreshold", "0.01"))
maxIgnore     := Number(IniRead(IniFile, IniSect, "MaxIgnore", "0"))
maxSilent     := Number(IniRead(IniFile, IniSect, "MaxSilent", "0"))
maxDefault    := Number(IniRead(IniFile, IniSect, "MaxDefault", "0"))
defDateDiff   := Number(IniRead(IniFile, IniSect, "DateDiffSec", "3600"))
notFoundWait  := Number(IniRead(IniFile, IniSect, "NotFoundSec", "1"))
iNotActivate  := Number(IniRead(IniFile, IniSect, "NotActivate", "1"))
iNotDefault   := Number(IniRead(IniFile, IniSect, "NotDefault", "1"))
iSyncPause    := Number(IniRead(IniFile, IniSect, "SyncPause", "0"))
iSyncStart    := Number(IniRead(IniFile, IniSect, "SyncStart", "0"))

TipsForeStart := IniRead(IniFile, IniSect, "TipsForeStart", "FFFFFF")
TipsBackStart := IniRead(IniFile, IniSect, "TipsBackStart", "3F3F3F")
TipsForeStop  := IniRead(IniFile, IniSect, "TipsForeStop", "9F9F9F")
TipsBackStop  := IniRead(IniFile, IniSect, "TipsBackStop", "3F3F3F")
TipsForeFind  := IniRead(IniFile, IniSect, "TipsForeFind", "CFCFCF")
TipsBackFind  := IniRead(IniFile, IniSect, "TipsBackFind", "3F3F3F")
TipsForeNotF  := IniRead(IniFile, IniSect, "TipsForeNotF", "7F7F7F")
TipsBackNotF  := IniRead(IniFile, IniSect, "TipsBackNotF", "3F3F3F")

DIFF_MAX := 999999
if( defDateDiff > DIFF_MAX ){
	defDateDiff := DIFF_MAX
}

;//前回のログを消去
if( iDelete || iLogLine ){
	try{
		FileDelete(LOG_PATH)
	}
}
;//デバッグログの初期処理
if( iDebug ){
	A_TrayMenu.Insert("4&", "Open LOG file", handleMenuItemLog)
	LogInit( "ActivePseudo", LOG_PATH,, iLogSJIS,,, iLogLine)
	LogOutput("ActivePseudo Start",,1)
	LogOutput("■Load Setting.",,1)
}


;//アクティブ切り替え対象の設定を読み込む
idx := 1
while(maxPath >= idx){
	idxStr := StrNum3(idx)
	strTemp := IniRead(IniFile, IniSect, "PATH" String(idx), "")
	arg_regx := 2
	if( StrUpper(SubStr(strTemp,1,6)) = "REGEX:" ){
		strTemp := TargetToREGEX(strTemp)
		arg_regx := "RegEx"
		strTemp := SubStr(strTemp,7)
	}
	pathArray.Push(strTemp)
	Regx.Push(arg_regx)
	
	;//targetからexe名のみ切り出す
	if( InStr(strTemp,"ahk_exe") > 0 ){
		aryTemp := StrSplit(strTemp,"ahk_exe ")
		strTemp := aryTemp[aryTemp.length]
		if( InStr(strTemp,"ahk_") > 0 ){
			aryTemp := StrSplit(strTemp," ahk_")
			strTemp := aryTemp[1]
		}
		strTemp := StrReplace(strTemp, "C:\Program Files (x86)", "")
		strTemp := StrReplace(strTemp, "C:\Program Files", "")
	}
	if( strTemp = "" ){
		strTemp := "(undefined file " idx ")"
	}
	fileArray.Push(strTemp)

	;//繰り返し回数の読み込み(REPS1～)
	strTemp := IniRead(IniFile, IniSect, "REPS" String(idx), "1")
	strTemp := StrReplace(strTemp, '"', "")
	repsArray.Push(strTemp)

	;//キー送出設定の読み込み(KEYS1～)
	strTemp := IniRead(IniFile, IniSect, "KEYS" String(idx), "0")
	strTemp := StrReplace(strTemp, '"', "")
	keysArray.Push(strTemp)

	;//タブ切り替え定義の読み込み(TABS1～)
	strTemp := IniRead(IniFile, IniSect, "TABS" String(idx), "0")
	;//両端のダブルクォートを削除し、カンマ区切りを配列に分割
	strTemp := StrReplace(strTemp, '"', "")
	aryTemp := StrSplit(strTemp, ",")
	if(aryTemp.Length < repsArray[idx]){
		aryTemp.Length := repsArray[idx] ;//繰り返し数よりもカンマ区切りの数が足りない
	}
	tabsStr := strTemp
	tabsArray.Push(aryTemp)
	
	;//F5送出間隔定義の読み込み(DIFF1～)
	strTemp := IniRead(IniFile, IniSect, "DIFF" String(idx), defDateDiff)
	if( Number(strTemp) > DIFF_MAX ){
		strTemp := DIFF_MAX
	}
	diffArray.Push(Number(strTemp))
	dateTmp := DateAdd( A_Now, -1 * diffArray[idx] - 1, "Seconds" )
	lastF5Array.Push(dateTmp)
	
	;//送信方式の読み込み(SEND1～)
	strTemp := IniRead(IniFile, IniSect, "SEND" String(idx), "1")
	sendArray.Push(Number(strTemp))
	
	;//ウィンドウスタイルの必須ビット
	strTemp := IniRead(IniFile, IniSect, "ALLOW" idx, "")
	strTemp := StrReplace(strTemp, '"', "")
	strTemp := StyleNumber(strTemp,WS_VISIBLE)
	allowArray.push(strTemp)
	
	;//ウィンドウスタイルの除外ビット
	strTemp := IniRead(IniFile, IniSect, "DENY" idx, "")
	strTemp := StrReplace(strTemp, '"', "")
	strTemp := StyleNumber(strTemp,WS_DISABLED)
	denyArray.push(strTemp)

	if( iDebug ){
		LogOutput("Target [" StrNum2(idxStr) "] Text= " REGEXToTarget(pathArray[idx]) " / RegExp= " Regx[idx],,1)
		LogOutput("            Allow= " StrHex8(allowArray[idx]) " / Deny= " StrHex8(denyArray[idx])
				  . " / REPS= " repsArray[idx] " / KEYS= " keysArray[idx] " / TABS= " tabsStr " / DIFF= " diffArray[idx],,1)
	}

	;//MsgBox("Path" idx " = " pathArray[idx])
	idx++
}

;//起動していたらActivePseudoの動作停止とする対象の設定を読み込む
idx := 1
while(maxIgnore >= idx){
	idxStr := StrNum3(idx)
	strTemp := IniRead(IniFile, IniSect, "IgnoreWindow" idx, "")

	arg_regx := 2
	if( StrUpper(SubStr(strTemp,1,6)) = "REGEX:" ){
		strTemp := TargetToREGEX(strTemp)
		arg_regx := "RegEx"
		strTemp := SubStr(strTemp,7)
	}
	ignoreWindow.push(strTemp)
	ignoreRegx.push(arg_regx)
	strTemp := IniRead(IniFile, IniSect, "IgnoreAllow" idx, "")
	strTemp := StyleNumber(strTemp,WS_VISIBLE)
	ignoreAllow.push(strTemp)
	strTemp := IniRead(IniFile, IniSect, "IgnoreDeny" idx, "")
	strTemp := StyleNumber(strTemp,WS_DISABLED)
	ignoreDeny.push(strTemp)
	
	if( iDebug ){
		strTemp := StrReplace(ignoreWindow[idx], "C:\Program Files (x86)", "")
		strTemp := StrReplace(strTemp, "C:\Program Files", "")
		LogOutput("Ignore [" StrNum2(idxStr) "] Text= " REGEXToTarget(ignoreWindow[idx]) " / RegExp= " ignoreRegx[idx],,1)
		LogOutput("            Allow= " StrHex8(ignoreAllow[idx]) " / Deny= " StrHex8(ignoreDeny[idx]),,1)
	}
	
	idx++
}

;//起動していたらダイアログとポップアップを出さない対象の設定を読み込む
idx := 1
while(maxSilent >= idx){
	idxStr := StrNum3(idx)
	strTemp := IniRead(IniFile, IniSect, "SilentWindow" idx, "")

	arg_regx := 2
	if( StrUpper(SubStr(strTemp,1,6)) = "REGEX:" ){
		strTemp := TargetToREGEX(strTemp)
		arg_regx := "RegEx"
		strTemp := SubStr(strTemp,7)
	}
	silentWindow.push(strTemp)
	silentRegx.push(arg_regx)
	strTemp := IniRead(IniFile, IniSect, "SilentAllow" idx, "")
	strTemp := StyleNumber(strTemp,WS_VISIBLE)
	silentAllow.push(strTemp)
	strTemp := IniRead(IniFile, IniSect, "SilentDeny" idx, "")
	strTemp := StyleNumber(strTemp,WS_DISABLED)
	silentDeny.push(strTemp)

	if( iDebug ){
		strTemp := StrReplace(silentWindow[idx], "C:\Program Files (x86)", "")
		strTemp := StrReplace(strTemp, "C:\Program Files", "")
		LogOutput("Silent [" StrNum2(idxStr) "] Text= " REGEXToTarget(silentWindow[idx]) " / RegExp= " silentRegx[idx],,1)
		LogOutput("            Allow= " StrHex8(silentAllow[idx]) " / Deny= " StrHex8(silentDeny[idx]),,1)
	}

	idx++
}

;//都度アクティブに切り替える対象の設定を読み込む
idx := 1
while(maxDefault >= idx){
	idxStr := StrNum3(idx)
	strTemp := IniRead(IniFile, IniSect, "DefaultWindow" idx, "")

	arg_regx := 2
	if( StrUpper(SubStr(strTemp,1,6)) = "REGEX:" ){
		strTemp := TargetToREGEX(strTemp)
		arg_regx := "RegEx"
		strTemp := SubStr(strTemp,7)
	}
	defaultWindow.push(strTemp)
	defaultRegx.push(arg_regx)
	strTemp := IniRead(IniFile, IniSect, "DefaultAllow" idx, "")
	strTemp := StyleNumber(strTemp,WS_VISIBLE)
	defaultAllow.push(strTemp)
	strTemp := IniRead(IniFile, IniSect, "DefaultDeny" idx, "")
	strTemp := StyleNumber(strTemp,WS_DISABLED)
	defaultDeny.push(strTemp)

	if( iDebug ){
		strTemp := StrReplace(defaultWindow[idx], "C:\Program Files (x86)", "")
		strTemp := StrReplace(strTemp, "C:\Program Files", "")
		LogOutput("Default[" StrNum2(idxStr) "] Text= " REGEXToTarget(defaultWindow[idx]) " / RegExp= " defaultRegx[idx],,1)
		LogOutput("            Allow= " StrHex8(defaultAllow[idx]) " / Deny= " StrHex8(defaultDeny[idx]),,1)
	}

	idx++
}


;//プロセス間通信
if( iSyncPause ){
	OnMessage(MSG_SYNC_PAUSE, DoSyncPauseAction)
	if( iDebug ){
		LogOutput("OnMessage[MSG_SYNC_PAUSE] Listening Start.")
	}
}

DoSyncPauseAction(wParam, lParam, msg, hwnd){
	if( iSyncPause ){
		if( iDebug ){
			LogOutput("OnMessage[MSG_SYNC_PAUSE] val:" StrHex4(lParam) " from:" StrHex4(wParam) "(" gObj_SyncPauseAppList[wParam] ")")
		}
		return SyncPause( MY_APP_ID, lParam, 0, DEF_MENU )
	}
}

if( iSyncStart ){
	OnMessage(MSG_SYNC_START, DoSyncStartAction)
	if( iDebug ){
		LogOutput("OnMessage[MSG_SYNC_START] Listening Start.")
	}
}

DoSyncStartAction(wParam, lParam, msg, hwnd){
	if( iSyncStart ){
		if( iDebug ){
			LogOutput("OnMessage[MSG_SYNC_START] val:" StrHex4(lParam) " from:" StrHex4(wParam) "(" gObj_SyncStartAppList[wParam] ")")
		}
		return SyncStart( MY_APP_ID, 0, execAfterWait )
	}
}


tipsDisplayOffset := 0
settingMin  := pastMin


;//GetCursorPos用のバッファを獲得
point       := Buffer(8)

;//エラー時にF5(CTRL+F5)を送出するメッセージ定義(ウィンドウタイトルの部分一致)
aryErrorMsg := [
	"ページを開けません",
	"ページが開けません",
	"サーバーが見つかりません",
	"アクセスできません",
	"接続できません",
	"Bad Gateway",
	"Connection timed out",
	"Internal Server Error",
	"しばらくお待ちください",
]

if(! noDialog){
	MsgBox("ウィンドウ切り替えの常駐を開始します",,"0x40040 T3")
}

idx := 1
targetPath := pathArray[idx]
targetFile := fileArray[idx]
targetRegEx := Regx[idx]
targetAllow := allowArray[idx]
targetDeny := denyArray[idx]
fullPath := ""
repeatTimes := repsArray[idx]
sendKeys := keysArray[idx]
sendFunc := sendArray[idx]
notFound := 0
enableF5 := 0
iEnableActivate := 0
iEnableDefault := 0
iScreenSaver := 0
strWinTitle := ""
lastLog := ""

/* 順次アクティブウィンドウを切り替えメインループ */
Loop
{
	global lastLog
	enableF5 := 0
	dateSub := DateDiff( A_Now, lastF5Array[idx], "Seconds" )
	if( diffArray[idx] > 0 && dateSub > diffArray[idx] ){
		lastF5Array[idx] := A_Now
		enableF5 := 1
	}

	count := repeatTimes
	while( count > 0 ){
		chkMove(1)
		notFound := 0
		multiHit := 0
		iEnableActivate := 1
		iEnableDefault := 1
		iScreenSaver := 0
		if( modeActive = 0 ){

			;//タイトルマッチモードの設定(2=部分一致, "RegEx"=正規表現)
			SetTitleMatchMode(targetRegEx)

			if( StrLen(targetPath) > 0 ){

				flgTarget := 0
				idxTg := 1
				hWnd := 0
				listWin := WinGetList(targetPath)
				
				if( listWin.length > 0 ){
					
					idxWin := 0
					for(hTgtW in listWin){
						idxWin := idxWin + 1
						if( iDebugTooltips ){
							SetTimer () => DestroyCustomToolTip(2), -30000
							ShowCustomToolTip( "[ActivePseudo] idx=" StrNum2(idx) " idxWin=" StrNum2(idxWin) "/" StrNum2(listWin.length) " [" targetFile "] hWnd=" hTgtW,
												A_ScreenWidth / 2 - tipsOffset*2 + tipsDisplayOffset, 50, 2, TipsForeStop, TipsBackStop, "", 1, 1, 1 )
						}

						if( hTgtW != 0 ){
							style := 0
							try{
								style := WinGetStyle("ahk_id " hTgtW)
							}
							if( TestStyle( style, targetAllow, targetDeny ) ){
								
								if( flgTarget = 0 ){
									flgTarget := 1
									;//forループを抜けるとhTgtWが0になるので保持する
									hWnd := hTgtW
								}else{
									multiHit := 1
								}

								multi := ""
								mark := " "
								if( multiHit ){
									multi := " [AnyWindows]"
									mark := "*"
								}

								if( iDebugTooltips ){
									SetTimer () => DestroyCustomToolTip(3), -30000
									ShowCustomToolTip( "[ActivePseudo] idx=" StrNum2(idx) " idxWin=" StrNum2(idxWin) "/" StrNum2(listWin.length)
														. " [" REGEXToTarget(targetFile) "] Match Style=" StrHex8(style) multi,
														A_ScreenWidth / 2 - tipsOffset*2 + tipsDisplayOffset, 75, 3, TipsForeStop, TipsBackStop, "", 1, 1, 1 )
								}
								if( iDebug ){
									LogOutput("Target" mark "idx=" StrNum2(idx) " idxWin=" StrNum2(idxWin) "/" StrNum2(listWin.length)
											. " (Tab=" StrNum2(repeatTimes - count + 1) "/" StrNum2(repeatTimes) ")"
											. " Match     Style=" StrHex8(style) " [" REGEXToTarget(targetFile) "]" multi)
									lastLog := ""
								}
								;//最初にヒットしたウィンドウを対象として処理するが、複数ヒットしてしまった事をログに残すのでbreakせず継続
								;break
							}else{
								if( iDebug ){
									LogOutput("Target idx=" StrNum2(idx) " idxWin=" StrNum2(idxWin) "/" StrNum2(listWin.length)
											. " (Tab=" StrNum2(repeatTimes - count + 1) "/" StrNum2(repeatTimes) ")"
											. " Not match Style=" StrHex8(style) " [" REGEXToTarget(targetFile) "]" )
									lastLog := ""
								}
							}
						}else{
							if( iDebug ){
								LogOutput("Target idx=" StrNum2(idx) " idxWin=" StrNum2(idxWin) "/" StrNum2(listWin.length)
										. " (Tab=" StrNum2(repeatTimes - count + 1) "/" StrNum2(repeatTimes) ")"
										. "hWnd=" hTgtW " hWnd ERROR [" REGEXToTarget(targetFile) "]")
								lastLog := ""
							}
						}
					}
					
				}else{

					if( iDebugTooltips ){
						DestroyCustomToolTip(3)
						SetTimer () => DestroyCustomToolTip(2), -30000
						ShowCustomToolTip( "[ActivePseudo] idx=" StrNum2(idx) " idxWin=00/" StrNum2(listWin.length) " [" targetFile "] NotFound",
											A_ScreenWidth / 2 - tipsOffset*2 + tipsDisplayOffset, 50, 2, TipsForeStop, TipsBackStop, "", 1, 1, 1 )
					}
					if( iDebug ){
						LogOutput("Target idx=" StrNum2(idx) " idxWin=00/" StrNum2(listWin.length)
								. " (Tab=" StrNum2(repeatTimes - count + 1) "/" StrNum2(repeatTimes) ")"
								. " NotFound  Style=0x00000000 [" REGEXToTarget(targetFile) "]" )
						lastLog := ""
					}

					if( noTgtDialog = 0 ){
						MsgBox( targetPath " not found", , "0x40010 T3")
					}
					notFound := 1
					if( displayMulti = 1 ){
						if( OutX < displayLimitS ){
							TipsDisplayOffset := tipsDisplayS
						}else if( OutX > displayLimitL ){
							TipsDisplayOffset := tipsDisplayL
						}else{
							TipsDisplayOffset := 0
						}
					}else{
						TipsDisplayOffset := 0
					}
				}
				
				if( flgTarget = 1 && hWnd != 0 ){
					;//自身以外の最前面固定ウィンドウが現在アクティブならターゲットにアクティブ切り替えをしない(explorerも除外)
					actExe := ""
					try{
						actExe := WinGetProcessName("A")
					}
					iExStyle := 0
					try{
						iExStyle := WinGetExStyle("A")
					}
					isTopMost := (iExStyle & WS_EX_TOPMOST = WS_EX_TOPMOST)
					isExclusion := ( (StrUpper(actExe) = StrUpper("ActivePseudo.exe")) || (StrUpper(actExe) = StrUpper("explorer.exe")) )
					iEnableActivate := ( ( ! isTopMost || isTopMost && isExclusion ) || ! iNotActivate )
					iEnableDefault := ( ( ! isTopMost || isTopMost && isExclusion ) || ! iNotDefault )
					if( iEnableActivate ){
						try {
							WinActivate( "ahk_id " hWnd )
							if( iDebug ){
								LogOutput("Activate idx=" StrNum2(idx) " hWnd=" hWnd " [" REGEXToTarget(targetFile) "]")
								lastLog := ""
							}
						}catch{
							hWnd := 0
							notFound := 1
						}
					}else{
						if( iDebug ){
							LogOutput("Current Windows is Top Most. Skip Activate Target. actExe =" actExe " / iEx=" StrHex8(iExStyle))
							lastLog := ""
						}
					}
					try{
						fullPath := WinGetProcessPath( "ahk_id " hWnd )
					}catch{
						hWnd := 0
						fullPath := ""
						notFound := 1
					}
					try{
						WinGetPos( &OutX, &OutY, &OutW, &OutH, "ahk_id " hWnd )
					} catch Error as err {
						hWnd := 0
						OutX := 0
						OutY := 0
						OutW := 0
						OutH := 0
						notFound := 1
					}
					if( notFound = 0 && displayMulti = 1 ){
						if( OutX < displayLimitS ){
							TipsDisplayOffset := tipsDisplayS
						}else if( OutX > displayLimitL ){
							TipsDisplayOffset := tipsDisplayL
						}else{
							TipsDisplayOffset := 0
						}
					}else{
						TipsDisplayOffset := 0
					}
					;//エラー停止している場合にF5送出(定期的にF5/CTRL+F5を送る設定のウィンドウのみ)
					try{
						strWinTitle := WinGetTitle("ahk_id " hWnd )
					}catch{
						strWinTitle := ""
					}
					For strErr in aryErrorMsg{
						if( strErr != "" && strWinTitle != "" ){
							if( InStr(strWinTitle, strErr) ){
								;//MsgBox("Find Error:" strWinTitle)
								lastF5Array[idx] := A_Now
								enableF5 := 2
							}
						}
					}
				}
				
			}else{
				
				MsgBox( "PATH" idx " setting error", , "0x40010 T3")
			}

			tim := repeatTimes - count + 1
			count--

			;//ターゲットウィンドウにキー送出
			if( notFound = 0 ){
				if( sendKeys = 1 ){
					try{
						if( tabsArray[idx][tim] != "0" ){
							Sleep(1000)
							;//コントロール数字でVivaldiのタブを切り替える
							switch(sendFunc){
							case 1:
								if( iEnableActivate ){
									Send("^" tabsArray[idx][tim])
								}
							case 2:
								if( iEnableActivate ){
									Send("{Ctrl Down}{" tabsArray[idx][tim] " Down}{" tabsArray[idx][tim] " Up}{Ctrl Up}")
								}
							case 3:
								ControlSend("^" tabsArray[idx][tim],, "ahk_id " hWnd )
							case 4:
								ControlSend("{Ctrl Down}{" tabsArray[idx][tim] " Down}{" tabsArray[idx][tim] " Up}{Ctrl Up}",, "ahk_id " hWnd )
							}
						}
					} catch Error as err {
						MsgBox( "TABS" idx "[" tim "] setting error",, "0x40010 T3")
					}
				}
				if( sendKeys = 2 ){
					if( enableF5 > 0 ){
						try{
							Sleep(1000)
							;//F5を送る
							switch(sendFunc){
							case 1:
								if( iEnableActivate ){
									Send("{F5}")
								}else{
									enableF5 := 0
								}
							case 2:
								if( iEnableActivate ){
									Send("{F5 Down}{F5 Up}")
								}else{
									enableF5 := 0
								}
							case 3:
								ControlSend("{F5}",, "ahk_id " hWnd )
							case 4:
								ControlSend("{F5 Down}{F5 Up}",, "ahk_id " hWnd )
							/*
							case 5:
								;//F5キー (VK_F5 = 0x74) を押す
								PostMessage(0x0100, 0x74, 0, , "ahk_id " hWnd)
								Sleep(10)
								;//F5キーを離す
								PostMessage(0x0101, 0x74, 0, , "ahk_id " hWnd)
							*/
							}
						} catch Error as err {
							MsgBox( "F5 setting error",, "0x40010 T3")
						}
					}
				}
				if( sendKeys = 3 ){
					if( enableF5 > 0 ){
						try{
							Sleep(1000)
							;//CTRL+F5を送る
							switch(sendFunc){
							case 1:
								if( iEnableActivate ){
									Send("^{F5}")
								}else{
									enableF5 := 0
								}
							case 2:
								if( iEnableActivate ){
									Send("{Ctrl Down}{F5 Down}{F5 Up}{Ctrl Up}")
								}else{
									enableF5 := 0
								}
							case 3:
								ControlSend("^{F5}",, "ahk_id " hWnd )
							case 4:
								ControlSend("{Ctrl Down}{F5 Down}{F5 Up}{Ctrl Up}",, "ahk_id " hWnd )
							/*
							case 5:
								;//Ctrlキー (VK_CONTROL = 0x11) を押す
								PostMessage(0x0100, 0x11, 0, , "ahk_id " hWnd)
								Sleep(10)
								;//F5キー (VK_F5 = 0x74) を押す
								PostMessage(0x0100, 0x74, 0, , "ahk_id " hWnd)
								Sleep(10)
								;//F5キーを離す
								PostMessage(0x0101, 0x74, 0, , "ahk_id " hWnd)
								Sleep(10)
								;//Ctrlキーを離す
								PostMessage(0x0101, 0x11, 0, , "ahk_id " hWnd)
							*/
							}
						} catch Error as err {
							MsgBox( "CTRL+F5 setting error",, "0x40010 T3")
						}
					}
				}
				
				;//常時表示ウィンドウを探して都度アクティブにする
				flgDefault := 0
				idxDf := 1
				hWnd := 0
				;//独自のスクリーンセーバーが動作している時は強制アクティブにはしない
				iScreenSaver := WinExist("CustomScreenSaver ahk_exe ScreenSaver.exe")
				if( ! iScreenSaver && iEnableDefault ){
					while(maxDefault >= idxDf){
						if( defaultWindow[idxDf] != "" ){
							
							SetTitleMatchMode( defaultRegx[idxDf] )
							listWin := WinGetList(defaultWindow[idxDf])
							idxWin := 0
							
							for(hDefW in listWin){
								idxWin := idxWin + 1

								defTarget := StrReplace(StrReplace(defaultWindow[idxDf],"C:\Program Files (x86)",""),"C:\Program Files","")
								if( iDebugTooltips ){
									SetTimer () => DestroyCustomToolTip(4), -30000
									ShowCustomToolTip( "[ActivePseudo] idxDf=" StrNum2(idxDf) " idxWin=" StrNum2(idxWin) "/" StrNum2(listWin.length) " [" defTarget "] hWnd=" hDefW,
														A_ScreenWidth / 2 - tipsOffset*2 + tipsDisplayOffset, 100, 4, TipsForeStop, TipsBackStop, "", 1, 1, 1 )
								}

								if( hDefW != 0 ){
									style := 0
									try{
										style := WinGetStyle("ahk_id " hDefW)
									}
									if( TestStyle( style, defaultAllow[idxDf], defaultDeny[idxDf] ) ){
										flgDefault := 1
										;//forループを抜けるとhDefWが0になるので保持する
										hWnd := hDefW

										if( iDebugTooltips ){
											SetTimer () => DestroyCustomToolTip(5), -30000
											ShowCustomToolTip( "[ActivePseudo] idxDf=" StrNum2(idxDf) " idxWin=" StrNum2(idxWin) "/" StrNum2(listWin.length) " [" defTarget "] "
																. "Match Style=" StrHex8(style),
																A_ScreenWidth / 2 - tipsOffset*2 + tipsDisplayOffset, 125, 5, TipsForeStop, TipsBackStop, "", 1, 1, 1 )
										}
										if( iDebug ){
											LogOutput("       Default idxDf=" StrNum2(idxDf) " idxWin=" StrNum2(idxWin) "/" StrNum2(listWin.length)
													. "   Match     Style=" StrHex8(style) " [" REGEXToTarget(defTarget) "]")
											lastLog := ""
										}
										;//複数対象があっても複数をアクティブにしてしまえという仕様にする
										Sleep(1000)
										try{
											WinMoveTop("ahk_id " hWnd)
										}
										try{
											WinActivate("ahk_id " hWnd)
										}
									}
								}
							}
						}
						idxDf++
					}
				}else{
					if( maxDefault >= idxDf ){
						if( iScreenSaver ){
							LogOutput("       Skip Default Window Activate. ScreenSaver is running.")
						}else{
							LogOutput("       Skip Default Window Activate. TopMostWindow is running.")
						}
					}
				}
			}
		}
		sleepLoop()
	}
	if( modeActive = 0 ){
		idx++
		if( maxPath < idx ){
			idx := 1
		}
		page := idx
		targetPath := pathArray[idx]
		targetFile := fileArray[idx]
		try{
			fullPath := WinGetProcessPath(targetPath)
		}catch{
			fullPath := ""
		}
		targetRegEx := Regx[idx]
		targetAllow := allowArray[idx]
		targetDeny := denyArray[idx]
		repeatTimes := repsArray[idx]
		sendKeys := keysArray[idx]
		sendFunc := sendArray[idx]
	}
}

;//座標を獲得して前回値と比較する
chkMove(mode){
;//mode: 1=メインループから 0=スリープ待ち合わせループから

	global idx,point,lastTime,lastX,lastY,targetPath,fullPath,modeActive,pastMin,sendKeys,enableF5,sendFunc,notFound,lastLog

	try {
		MouseGetPos( &posX, &posY, &posWin, &posCtrl )
	} catch Error as err {
		return
	}
/*
	DllCall("GetCursorPos", "Ptr", point, "Int")
	posX := NumGet(point, 0, "Int")
	posY := NumGet(point, 4, "Int")
*/
	;//タイトルマッチモードの設定(2=部分一致, "RegEx"=正規表現)
	SetTitleMatchMode(2)

	;//存在したら動作を中断する対象の捜索
	hW := 0
	flgIgnore := 0
	
	;//音声再生中は停止させる設定の場合
	if( audioPlaying ){
		if( CheckAudioChange(audioThreshold) ){
			flgIgnore := 1
			if( iDebug && mode & modeActive = 0 ){
				txtLog := "       Ignore  Audio Playing"
				if( lastLog != txtLog ){
					lastLog := txtLog
					LogOutput(txtLog)
				}
			}
		}
	}
	
	idxIg := 1
	while(maxIgnore >= idxIg){
		if( ignoreWindow[idxIg] != "" ){
			
			SetTitleMatchMode( ignoreRegx[idxIg] )
			listWin := WinGetList(ignoreWindow[idxIg])
			if( listWin.length > 0 ){
				idxWin := 0
				for(hW in listWin){
					idxWin := idxWin + 1
					if( hW != 0 ){
						style := 0
						try{
							style := WinGetStyle("ahk_id " hW)
						}
						if( TestStyle( style, ignoreAllow[idxIg], ignoreDeny[idxIg] ) ){
							if( iDebug && mode && modeActive = 0 ){
								txtLog := "       Ignore  idxIg=" StrNum2(idxIg) " idxWin=" StrNum2(idxWin) "/" StrNum2(listWin.length)
										. "   Match     Style=" StrHex8(style) " [" REGEXToTarget(ignoreWindow[idxIg]) "]"
								if( lastLog != txtLog ){
									lastLog := txtLog
									LogOutput(txtLog)
								}
							}
							flgIgnore := 1
							break
						}
					}
				}
				if( flgIgnore ){
					break
				}
			}
		}
		idxIg++
	}

	;//存在したらダイアログやポップアップを抑止する対象の捜索
	hW := 0
	flgSilent := 0
	idxSi := 1
	while(maxSilent >= idxSi){
		if( silentWindow[idxSi] != "" ){
			
			SetTitleMatchMode( silentRegx[idxSi] )
			listWin := WinGetList(silentWindow[idxSi])
			if( listWin.length > 0 ){
				idxWin := 0
				for(hW in listWin){
					idxWin := idxWin + 1
					if( hW != 0 ){
						style := 0
						try{
							style := WinGetStyle("ahk_id " hW)
						}
						if( TestStyle( style, silentAllow[idxSi], silentDeny[idxSi] ) ){
							if( iDebug && mode && modeActive = 0 ){
								txtLog := "       Silent  idxSi=" StrNum2(idxSi) " idxWin=" StrNum2(idxWin) "/" StrNum2(listWin.length)
										. "   Match     Style=" StrHex8(style) " [" REGEXToTarget(silentWindow[idxSi]) "]"
								if( lastLog != txtLog ){
									lastLog := txtLog
									LogOutput(txtLog)
								}
							}
							flgSilent := 1
							break
						}
					}
				}
				if( flgSilent ){
					break
				}
			}
		}
		idxSi++
	}

	SetTitleMatchMode(2)
	
	;//マウスカーソルの移動を検知または中止判定とするウィンドウがあったら中断
	if( ((Abs(posX - lastX) > POS_LIMIT || Abs(posY - lastY) > POS_LIMIT) && mouseLimitY > posY) || flgIgnore = 1 ){
		lastX := posX
		lastY := posY
		lastTime := A_Now
		if( modeActive = 0 ){
			DestroyCustomToolTip(1)
			if(msgTime > 0){
				if( ! flgSilent && ! noDialog){
					MsgBox( "自動切り替えを中断します", , "0x40030 T" msgTime)
				}
			}else{
				if( displayMulti = 1 ){
					xpos := A_ScreenWidth / 2 - tipsOffset + tipsDisplayOffset
					xfix := 0
				}else{
					xpos := ""
					xfix := 1
				}
				;//先にタイマーを再設定することですれ違いを抑止する
				SetTimer () => FadeoutCustomToolTip(1,510), -4500
				if( ! flgSilent ){
					ShowCustomToolTip( "[ActivePseudo] 自動切り替えを中断します",
										xpos, 0, 1, TipsForeStop, TipsBackStop,, xfix, 1, 1 )
				}
			}
			if( iDebug ){
				LogOutput("■Paused.")
				lastLog := ""
			}
		}
		modeActive := 1
	}
	;//マウスカーソルが一定時間動いていないなら再開
	past := DateDiff( A_Now, lastTime, "Seconds" )
	if( past > pastMin * 60 ){
		if( modeActive = 1 ){
			DestroyCustomToolTip(1)
			if(msgTime > 0){
				if( ! flgSilent && ! noDialog){
					MsgBox( "自動切り替えを開始します", , "0x40040 T" msgTime)
				}
			}else{
				if( displayMulti = 1 ){
					xpos := A_ScreenWidth / 2 - tipsOffset + tipsDisplayOffset
					xfix := 0
				}else{
					xpos := ""
					xfix := 1
				}
				;//先にタイマーを再設定することですれ違いを抑止する
				SetTimer () => FadeoutCustomToolTip(1,510), -4500
				if( ! flgSilent ){
					ShowCustomToolTip( "[ActivePseudo] 自動切り替えを開始します",
										xpos, 0, 1, TipsForeStart, TipsBackStart,, xfix, 1, 1 )
				}
			}
			if( iDebug ){
				LogOutput("■Start.")
				lastLog := ""
			}
			lastX := posX
			lastY := posY
		}
		modeActive := 0
	}
	;//MsgBox( "past=" past " POS X=" posX ",Y=" posY, , "0x40000 T1" )
	
	;//状況をポップアップにて表示
	if( modeActive = 0 && repeatTimes != count ){
		strF5 := "(no send F5 / CTRL+F5)"
		if( sendKeys = 2 ){
			if( enableF5 > 0 ){
				strF5 := " (past=" StrNum6(dateSub) "/diff=" StrNum6(diffArray[idx]) " Send[F5] Func[" sendFunc "])"
			}else{
				strF5 := " (past=" StrNum6(dateSub) "/diff=" StrNum6(diffArray[idx]) ")"
			}
		}
		if( sendKeys = 3 ){
			if( enableF5 > 0 ){
				strF5 := " (past=" StrNum6(dateSub) "/diff=" StrNum6(diffArray[idx]) " Send[CTRL+F5] Func[" sendFunc "])"
			}else{
				strF5 := " (past=" StrNum6(dateSub) "/diff=" StrNum6(diffArray[idx]) ")"
			}
		}
		if( fullPath = "" ){
			try{
				fullPath := WinGetProcessPath(targetPath)
			}catch{
				try{
					;//ウィンドウが見つからない時は定義から切り取る
					idx1 := InStr(targetPath,"ahk_exe ")
					idx2 := InStr(targetPath,"ahk_class ")
					if( idx1 > 0 && idx2 > 0 ){
						if( idx1 = 0 ){
							idx1 := 1
						}else{
							idx1 := idx1 + 8
						}
						if( idx2 < idx1 ){
							fullPath := Trim(SubStr(targetPath, idx1))
						}else{
							fullPath := Trim(SubStr(targetPath, idx1, idx2-idx1))
						}
					}else{
						fullPath := targetPath
					}
				}catch{
					fullPath := "Name string error."
				}
			}
		}
		if( displayMulti = 1 ){
			xpos := A_ScreenWidth / 2 - tipsOffset + tipsDisplayOffset
			xfix := 0
		}else{
			xpos := ""
			xfix := 1
		}
		if(notFound = 0){
			if( iDebug ){
				txtLog := "Window=" StrNum2(page) "/" StrNum2(maxPath) " Tab=" StrNum2(repeatTimes - count) "/" StrNum2(repeatTimes) " " strF5 " / path=" fullPath
				if( lastLog != txtLog ){
					lastLog := txtLog
					LogOutput(txtLog)
				}
			}
			if( ! flgSilent ){
				ShowCustomToolTip( "[ActivePseudo] Window=" StrNum2(page) "/" StrNum2(maxPath) " Tab=" StrNum2(repeatTimes - count) "/" StrNum2(repeatTimes) " " strF5 "`n"
									. "path=" fullPath, xpos, 0, 1, TipsForeFind, TipsBackFind,, xfix, 1, 1 )
			}
		}else{
			if( ! flgSilent ){
				ShowCustomToolTip( "[ActivePseudo] Window=" StrNum2(page) "/" StrNum2(maxPath) " Tab=" StrNum2(repeatTimes - count) "/" StrNum2(repeatTimes) " ( Window not found. Skip.)`n"
									. "path=" fullPath, xpos, 0, 1, TipsForeNotF, TipsBackNotF,, xfix, 1, 1 )
			}
		}
	}
}

;//途中で座標を確認しながら待機する
sleepLoop(){
	global modeActive,count,intervalSec
	if(notFound = 0){
		sleepCount := intervalSec * 1000
	}else{
		sleepCount := notFoundWait * 1000
	}
	while( sleepCount > 0 ){
		lastActive := modeActive
		chkMove(0)
		if( modeActive = 1 && lastActive = 0 ){
			sleepCount := 0
		}else{
			sleepCount := sleepCount - 250
			Sleep(250)
		}
	}
}

;//待たずに即時開始
execAfterWait(){
	
	global lastTime,lastX,lastY
	
	if(! noDialog){
		MsgBox( "5秒後に自動切り替えを開始します", , "0x40040 T5")
	}else{
		Sleep(5000)
	}
	try {
		;開始直後に停止してしまうので現時点の座標で上書き
		MouseGetPos( &posX, &posY, &posWin, &posCtrl )
		lastX := posX
		lastY := posY
		lastTime := DateAdd( A_Now, -1 * pastMin * 60, "Seconds" )
	}
}

;//メニューからの呼び出し
handleMenuItemStart(ItemName, ItemPos, MyMenu){
	if( iDebug ){
		LogOutput("Exec from Menu" )
	}
	SyncStart( MY_APP_ID, iSyncStart, execAfterWait )
}

handleMenuItemReload(ItemName, ItemPos, MyMenu){
	Reload
}

handleMenuItemEdit(ItemName, ItemPos, MyMenu){
	try {
		Run(IniFile)
	}
}

handleMenuItemStop(ItemName, ItemPos, MyMenu){
	if( iDebug ){
		LogOutput("Pause from Menu" )
	}
	SyncPause( MY_APP_ID, -1, iSyncPause, DEF_MENU )
}

handleMenuItemLog(ItemName, ItemPos, MyMenu){
	try {
		Run(LOG_PATH)
	}
}

